<?php

namespace App\Http\Controllers;

use App\Models\AktivitasLuar;
use Illuminate\Http\Request;

class AktivitasLuarController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $aktivitasLuars = AktivitasLuar::orderBy('nama_aktivitas')->paginate(10);
        return view('aktivitas-luar.index', compact('aktivitasLuars'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('aktivitas-luar.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama_aktivitas' => 'required|string|max:255|unique:aktivitas_luars,nama_aktivitas',
            'deskripsi' => 'nullable|string',
            'is_active' => 'boolean'
        ]);

        AktivitasLuar::create($request->all());

        return redirect()->route('aktivitas-luar.index')
            ->with('success', 'Aktivitas luar berhasil ditambahkan.');
    }

    /**
     * Display the specified resource.
     */
    public function show(AktivitasLuar $aktivitasLuar)
    {
        return view('aktivitas-luar.show', compact('aktivitasLuar'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(AktivitasLuar $aktivitasLuar)
    {
        return view('aktivitas-luar.edit', compact('aktivitasLuar'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, AktivitasLuar $aktivitasLuar)
    {
        $request->validate([
            'nama_aktivitas' => 'required|string|max:255|unique:aktivitas_luars,nama_aktivitas,' . $aktivitasLuar->id,
            'deskripsi' => 'nullable|string',
            'is_active' => 'boolean'
        ]);

        $aktivitasLuar->update($request->all());

        return redirect()->route('aktivitas-luar.index')
            ->with('success', 'Aktivitas luar berhasil diperbarui.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AktivitasLuar $aktivitasLuar)
    {
        $aktivitasLuar->delete();

        return redirect()->route('aktivitas-luar.index')
            ->with('success', 'Aktivitas luar berhasil dihapus.');
    }
}
