<?php

namespace App\Helpers;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;

class UrlHelper
{
    /**
     * Generate slug dari nama
     */
    public static function generateSlug($name)
    {
        return Str::slug($name, '-');
    }
    
    /**
     * Encrypt ID untuk URL
     */
    public static function encryptId($id)
    {
        return Crypt::encryptString($id);
    }
    
    /**
     * Decrypt ID dari URL
     */
    public static function decryptId($encryptedId)
    {
        try {
            return Crypt::decryptString($encryptedId);
        } catch (\Exception $e) {
            return null;
        }
    }
    
    /**
     * Generate URL slug untuk anggota
     */
    public static function generateAnggotaUrl($id, $nama)
    {
        $slug = self::generateSlug($nama);
        $encryptedId = self::encryptId($id);
        
        return $slug . '-' . $encryptedId;
    }
    
    /**
     * Parse URL slug untuk mendapatkan ID
     */
    public static function parseAnggotaUrl($urlSlug)
    {
        // Split berdasarkan dash terakhir (karena encrypted ID pasti di akhir)
        $parts = explode('-', $urlSlug);
        
        if (count($parts) < 2) {
            return null;
        }
        
        // Ambil encrypted ID (bagian terakhir)
        $encryptedId = end($parts);
        
        // Decrypt ID
        $id = self::decryptId($encryptedId);
        
        if (!$id) {
            return null;
        }
        
        // Ambil slug (semua bagian kecuali yang terakhir)
        $slug = implode('-', array_slice($parts, 0, -1));
        
        return [
            'id' => $id,
            'slug' => $slug
        ];
    }
    
    /**
     * Generate route URL untuk anggota
     */
    public static function anggotaRoute($routeName, $id, $nama, $params = [])
    {
        $urlSlug = self::generateAnggotaUrl($id, $nama);
        return route($routeName, array_merge(['anggota' => $urlSlug], $params));
    }
    
    /**
     * Generate route URL untuk kegiatan
     */
    public static function kegiatanRoute($routeName, $id, $nama, $params = [])
    {
        $urlSlug = self::generateAnggotaUrl($id, $nama);
        return route($routeName, array_merge(['kegiatan' => $urlSlug], $params));
    }
}
