<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class UpaGroupActivityExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    /** @var \Illuminate\Support\Collection */
    private $activities;

    public function __construct(Collection $activities)
    {
        $this->activities = $activities;
    }

    public function collection()
    {
        return $this->activities;
    }

    public function headings(): array
    {
        return [
            'No',
            'Kode UPA',
            'Nama UPA',
            'Nama Pembimbing',
            'Tanggal',
            'Waktu',
            'Status Pembimbing',
            'Total Kehadiran',
            'Total Anggota',
            'Status Terlaksana',
            'Agenda',
        ];
    }

    public function map($activity): array
    {
        $agendaText = '';
        if (is_array($activity->agenda_notes) && count($activity->agenda_notes) > 0) {
            $names = [];
            foreach ($activity->agenda_notes as $item) {
                if (!empty($item['nama_agenda'])) {
                    $names[] = $item['nama_agenda'];
                }
            }
            $agendaText = implode('; ', $names);
        } else {
            $agendaText = (string) ($activity->agenda_upa ?? '');
        }

        return [
            '', // No will be filled by Excel index
            $activity->kode_upa,
            optional($activity->upa)->nama_upa,
            $activity->nama_pembimbing,
            optional($activity->tanggal_upa) ? date('d/m/Y', strtotime($activity->tanggal_upa)) : '',
            optional($activity->waktu_upa) ? date('H:i', strtotime($activity->waktu_upa)) : '',
            $activity->kehadiran_pembimbing ? 'Hadir' : 'Tidak Hadir',
            (string) ($activity->total_kehadiran ?? 0),
            (string) ($activity->total_anggota ?? 0),
            $activity->status_terlaksana,
            $agendaText,
        ];
    }
}



