<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AnggotaTemplateExport implements FromArray, WithHeadings, WithStyles, WithColumnWidths
{
    public function array(): array
    {
        // Return empty array for template
        return [];
    }

    public function headings(): array
    {
        return [
            'NIA',
            'Nama Lengkap',
            'Jenis Kelamin (L/P)',
            'Tempat Lahir',
            'Tanggal Lahir (YYYY-MM-DD)',
            'Alamat',
            'Kota',
            'Provinsi',
            'No Telepon',
            'Email',
            'Jenjang ID',
            'Grup UPA ID',
            'DPD ID',
            'DPC ID',
            'Tanggal Bergabung (YYYY-MM-DD)',
            'Status Keanggotaan',
            'Keahlian (pisahkan dengan koma)',
            'Catatan Profil'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 15,  // NIA
            'B' => 25,  // Nama Lengkap
            'C' => 20,  // Jenis Kelamin
            'D' => 20,  // Tempat Lahir
            'E' => 20,  // Tanggal Lahir
            'F' => 40,  // Alamat
            'G' => 20,  // Kota
            'H' => 20,  // Provinsi
            'I' => 15,  // No Telepon
            'J' => 30,  // Email
            'K' => 15,  // Jenjang ID
            'L' => 15,  // Grup UPA ID
            'M' => 15,  // DPD ID
            'N' => 15,  // DPC ID
            'O' => 20,  // Tanggal Bergabung
            'P' => 20,  // Status Keanggotaan
            'Q' => 30,  // Keahlian
            'R' => 40,  // Catatan Profil
        ];
    }
}
