<?php

namespace App\Exports;

use App\Models\Anggota;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AnggotaExport implements FromCollection, WithHeadings, WithMapping, WithStyles, WithColumnWidths
{
    protected $anggota;

    public function __construct($anggota)
    {
        $this->anggota = $anggota;
    }

    public function collection()
    {
        return $this->anggota;
    }

    public function headings(): array
    {
        return [
            'No',
            'NIA',
            'Nama Lengkap',
            'Jenis Kelamin',
            'Kota',
            'Kode Pos',
            'Jenjang',
            'Grup UPA',
            'Status',
            'Email',
            'No Telepon',
            'Tempat Lahir',
            'Tanggal Lahir',
            'Alamat',
            'Provinsi',
            'DPD',
            'DPC',
            'Keahlian',
            'Tanggal Bergabung'
        ];
    }

    public function map($anggota): array
    {
        static $counter = 0;
        $counter++;
        
        return [
            $counter,
            $anggota->nomor_identitas_anggota,
            $anggota->nama_lengkap,
            $anggota->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan',
            $anggota->kota,
            $anggota->kode_pos ?? '-',
            $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota,
            $anggota->refGrupUpa->nama_grup_upa ?? '-',
            $anggota->status_keanggotaan,
            $anggota->email,
            $anggota->no_telepon,
            $anggota->tempat_lahir,
            $anggota->tanggal_lahir ? \Carbon\Carbon::parse($anggota->tanggal_lahir)->format('d/m/Y') : '-',
            $anggota->alamat,
            $anggota->provinsi,
            $anggota->dpd->nama_dpd ?? '-',
            $anggota->dpc->nama_dpc ?? '-',
            $anggota->keahlian->pluck('nama_keahlian')->join(', '),
            $anggota->tanggal_bergabung ? \Carbon\Carbon::parse($anggota->tanggal_bergabung)->format('d/m/Y') : '-'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 5,   // No
            'B' => 15,  // NIA
            'C' => 25,  // Nama Lengkap
            'D' => 15,  // Jenis Kelamin
            'E' => 20,  // Kota
            'F' => 12,  // Kode Pos
            'G' => 15,  // Jenjang
            'H' => 20,  // Grup UPA
            'I' => 15,  // Status
            'J' => 30,  // Email
            'K' => 15,  // No Telepon
            'L' => 20,  // Tempat Lahir
            'M' => 15,  // Tanggal Lahir
            'N' => 40,  // Alamat
            'O' => 20,  // Provinsi
            'P' => 20,  // DPD
            'Q' => 20,  // DPC
            'R' => 30,  // Keahlian
            'S' => 15,  // Tanggal Bergabung
        ];
    }
}
