# Yaumiyah Filter & Export Excel Feature

## Overview
Fitur filter dan export Excel untuk modul Yaumiyah telah berhasil diimplementasikan. Fitur ini memungkinkan pengguna untuk memfilter data aktivitas yaumiyah berdasarkan berbagai kriteria dan mengekspornya ke file Excel.

## Masalah yang Ditemukan dan Diperbaiki

### Masalah 1: Dropdown Tidak Terlihat
**Issue**: Dropdown "Anggota" dan "Aktivitas" hampir tidak terlihat karena:
- Select2 Bootstrap 5 CSS belum dimuat
- Konflik antara inisialisasi Select2 di layout dan di view
- Theme yang tidak sesuai (bootstrap4 vs bootstrap-5)

**Solusi**:
1. Menambahkan Select2 Bootstrap 5 CSS di layout app.blade.php
2. Menghapus duplikasi inisialisasi Select2 di view yaumiyah
3. Mengupdate inisialisasi Select2 di layout untuk mendukung placeholder dinamis

### Masalah 2: Header Overlap
**Issue**: Dua header oranye bertumpuk satu sama lain sehingga terlihat kurang rapi.

**Solusi**:
1. Mengubah struktur header menjadi model yang sama dengan halaman Data Kegiatan
2. Header utama dengan judul dan subjudul di sebelah kiri
3. Tombol Export Excel di sebelah kanan header
4. Filter section dengan header gradient orange terpisah
5. Menggunakan class `bg-gradient-primary` untuk styling yang konsisten

## Fitur yang Ditambahkan

### 1. Filter Data
- **Filter Anggota**: Pilih anggota tertentu atau tampilkan semua anggota (dengan Select2 dropdown)
- **Filter Pekan**: Filter berdasarkan nomor pekan (1-53)
- **Filter Tahun**: Filter berdasarkan tahun (2020-2030)
- **Filter Aktivitas**: Pilih aktivitas tertentu atau tampilkan semua aktivitas (dengan Select2 dropdown)
- **Reset Filter**: Tombol untuk mereset semua filter

### 2. Export Excel
- Export data ke format Excel (.xlsx)
- Kolom yang diekspor:
  - No
  - NIA
  - Nama Anggota
  - Pekan
  - Tahun
  - Aktivitas
  - Nilai
  - Unit
  - Target/Minggu
  - Input Oleh
  - Tanggal Input
- Styling Excel:
  - Header dengan background biru (#4472C4)
  - Font putih pada header
  - Kolom terformat dengan lebar yang sesuai
  - Alignment yang tepat

### 3. Tampilan Data
- Statistik diperbarui untuk menampilkan:
  - Total Aktivitas
  - Jumlah Data Pekan Ini
  - Jumlah Data Tahun Ini
- Tabel data yaumiyah dengan pagination
- Responsif dan mudah digunakan

## File yang Dimodifikasi

### 1. Controller
**File**: `app/Http/Controllers/YaumiyahController.php`
- Menambahkan parameter filter pada method `index()`
- Menambahkan method `export()` untuk export Excel
- Menambahkan import `App\Exports\YaumiyahRecordExport` dan `Maatwebsite\Excel\Facades\Excel`

### 2. Export Class
**File**: `app/Exports/YaumiyahRecordExport.php` (BARU)
- Class untuk menangani export Excel
- Implements: `FromCollection`, `WithHeadings`, `WithMapping`, `WithStyles`, `WithColumnWidths`, `WithTitle`
- Support filter berdasarkan anggota_id, week, dan year
- Styling Excel yang profesional

### 3. View
**File**: `resources/views/yaumiyah/index.blade.php`
- Menambahkan form filter dengan Select2 (tanpa duplikasi inisialisasi)
- Menambahkan tombol Export Excel
- Menambahkan tombol Reset Filter
- Menambahkan tabel data yaumiyah dengan pagination
- Update statistik cards
- Menghapus script duplikat untuk Select2

### 4. Layout
**File**: `resources/views/layouts/app.blade.php`
- Menambahkan Select2 Bootstrap 5 CSS: `https://cdn.jsdelivr.net/npm/[email protected]/dist/css/select2-bootstrap-5-theme.min.css`
- Mengupdate inisialisasi Select2 untuk mendukung placeholder dinamis dan allowClear

### 5. Routes
**File**: `routes/web.php`
- Menambahkan route: `Route::get('/export', [YaumiyahController::class, 'export'])->name('export');`

## Cara Penggunaan

### Filter Data
1. Buka halaman Yaumiyah
2. Gunakan dropdown dan input field untuk memilih filter:
   - Pilih Anggota dari dropdown Select2 (dengan arrow indicator)
   - Masukkan nomor Pekan (opsional)
   - Masukkan Tahun (opsional, default: tahun sekarang)
   - Pilih Aktivitas dari dropdown Select2 (dengan arrow indicator)
3. Klik tombol "Filter" untuk menerapkan filter
4. Klik tombol "Reset Filter" untuk menghapus semua filter

### Export Excel
1. Setelah memfilter data (atau tanpa filter untuk export semua data)
2. Klik tombol "Export Excel"
3. File Excel akan terunduh dengan nama `data-yaumiyah.xlsx`
4. Data yang diekspor akan mengikuti filter yang sedang aktif

## Teknologi yang Digunakan
- Laravel Excel (Maatwebsite)
- Select2 Bootstrap 5 untuk dropdown yang lebih baik
- Bootstrap 5 untuk styling
- jQuery untuk JavaScript
- AdminLTE untuk UI framework

## Catatan Penting
- Filter dapat dikombinasikan untuk mendapatkan hasil yang lebih spesifik
- Export akan mengikuti filter yang sedang aktif
- Pagination memungkinkan navigasi data yang lebih mudah
- Statistik diperbarui secara otomatis berdasarkan data aktual
- Select2 dropdown sekarang terlihat jelas dengan arrow indicator
- Tidak ada duplikasi inisialisasi Select2 yang menyebabkan konflik

## Testing
Lakukan testing untuk memastikan:
1. Dropdown Anggota dan Aktivitas terlihat dengan jelas
2. Dropdown dapat dibuka dan opsi dapat dipilih
3. Filter berfungsi dengan benar
4. Export Excel berfungsi dan file dapat didownload
5. Reset filter berfungsi dengan benar
6. Pagination berfungsi dengan benar

