# Yaumiyah API Documentation

API untuk Portal Member Yaumiyah - memungkinkan member mengisi data yaumiyah secara mandiri.

## Base URL
```
http://your-domain.com/api/yaumiyah
```

## Authentication
API ini tidak memerlukan authentication khusus, namun disarankan untuk menggunakan API key atau token untuk keamanan.

## Endpoints

### 1. Get Activities
Mendapatkan daftar aktivitas yaumiyah yang aktif.

**URL:** `GET /api/yaumiyah/activities`

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "name": "Shalat berjamaah di Masjid",
            "description": "Shalat berjamaah di masjid dengan target maksimal 35 kali per pekan",
            "target_per_week": 35,
            "unit": "kali",
            "is_active": true,
            "sort_order": 2,
            "created_at": "2025-09-27T13:00:00.000000Z",
            "updated_at": "2025-09-27T13:00:00.000000Z"
        }
    ]
}
```

### 2. Get Records
Mendapatkan data yaumiyah untuk anggota tertentu pada pekan dan tahun tertentu.

**URL:** `GET /api/yaumiyah/records`

**Parameters:**
- `anggota_id` (required): ID anggota
- `week_number` (required): Nomor pekan (1-53)
- `year` (required): Tahun (2020-2030)

**Example:**
```
GET /api/yaumiyah/records?anggota_id=1&week_number=1&year=2025
```

**Response:**
```json
{
    "success": true,
    "data": {
        "1": {
            "id": 1,
            "yaumiyah_activity_id": 1,
            "anggota_id": 1,
            "week_number": 1,
            "year": 2025,
            "value": 35,
            "notes": "Catatan tambahan",
            "created_by": "member",
            "created_by_name": "John Doe",
            "activity": {
                "id": 1,
                "name": "Shalat berjamaah di Masjid",
                "unit": "kali"
            }
        }
    }
}
```

### 3. Store Records
Menyimpan data yaumiyah untuk anggota tertentu.

**URL:** `POST /api/yaumiyah/records`

**Request Body:**
```json
{
    "anggota_id": 1,
    "week_number": 1,
    "year": 2025,
    "member_name": "John Doe",
    "records": [
        {
            "yaumiyah_activity_id": 1,
            "value": 35,
            "notes": "Catatan tambahan"
        },
        {
            "yaumiyah_activity_id": 2,
            "value": 7,
            "notes": ""
        }
    ]
}
```

**Response:**
```json
{
    "success": true,
    "message": "Data Yaumiyah berhasil disimpan."
}
```

## Field Descriptions

### YaumiyahRecord Fields
- `yaumiyah_activity_id`: ID aktivitas yaumiyah
- `anggota_id`: ID anggota
- `week_number`: Nomor pekan (1-53)
- `year`: Tahun
- `value`: Nilai pencapaian
- `notes`: Catatan tambahan
- `created_by`: Siapa yang membuat data ('admin' atau 'member')
- `created_by_name`: Nama pembuat data

### YaumiyahActivity Fields
- `id`: ID aktivitas
- `name`: Nama aktivitas
- `description`: Deskripsi aktivitas
- `target_per_week`: Target per minggu
- `unit`: Unit pengukuran (kali, juz, ayat, dll)
- `is_active`: Status aktif
- `sort_order`: Urutan tampil

## Error Responses

### Validation Error
```json
{
    "message": "The given data was invalid.",
    "errors": {
        "anggota_id": ["The anggota id field is required."],
        "week_number": ["The week number must be between 1 and 53."]
    }
}
```

### Not Found Error
```json
{
    "message": "No query results for model [App\\Models\\Anggota] 999"
}
```

## Usage Example (JavaScript)

```javascript
// Get activities
fetch('/api/yaumiyah/activities')
    .then(response => response.json())
    .then(data => {
        console.log('Activities:', data.data);
    });

// Get records for specific member and week
fetch('/api/yaumiyah/records?anggota_id=1&week_number=1&year=2025')
    .then(response => response.json())
    .then(data => {
        console.log('Records:', data.data);
    });

// Store records
fetch('/api/yaumiyah/records', {
    method: 'POST',
    headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
    },
    body: JSON.stringify({
        anggota_id: 1,
        week_number: 1,
        year: 2025,
        member_name: 'John Doe',
        records: [
            {
                yaumiyah_activity_id: 1,
                value: 35,
                notes: 'Catatan tambahan'
            }
        ]
    })
})
.then(response => response.json())
.then(data => {
    console.log('Response:', data);
});
```

## Notes

1. **Data Replacement**: Setiap kali menyimpan data untuk pekan yang sama, data lama akan dihapus dan diganti dengan data baru.

2. **Created By Tracking**: Sistem akan otomatis menandai data yang dibuat oleh member dengan `created_by: 'member'` dan `created_by_name` sesuai nama yang dikirim.

3. **Validation**: Semua input akan divalidasi sesuai dengan aturan yang telah ditetapkan.

4. **Database**: Data disimpan dalam tabel `yaumiyah_records` dengan struktur yang sama dengan sistem admin.
