# 🎨 Panduan Tema PKS - BKD PD

## Overview
Sistem BKD PD telah menggunakan tema orange dusty yang konsisten dengan identitas Partai Keadilan Sejahtera (PKS). Tema ini diterapkan pada semua halaman authentication dan dashboard dengan warna yang lebih soft dan elegan.

## 🎨 Color Palette

### Primary Colors
- **PKS Orange Dusty**: `#F0833A` - Warna utama PKS (Dusty Orange)
- **PKS Orange Dark**: `#E67E22` - Warna gelap untuk hover dan emphasis
- **PKS Orange Light**: `#F39C12` - Warna terang untuk aksen
- **PKS Orange Lighter**: `#FDEBD0` - Warna sangat terang untuk background

### Secondary Colors
- **PKS Gray**: `#424242` - Warna teks utama
- **PKS Gray Light**: `#757575` - Warna teks sekunder

## 🔐 Halaman Authentication

### Login Page (`/login`)
- **Background**: Gradient orange PKS
- **Card**: White dengan border orange subtle
- **Header**: Gradient orange dengan icon floating animation
- **Form Elements**: 
  - Input focus: Border orange dengan shadow
  - Button: Gradient orange dengan hover effect
  - Icons: Orange color scheme
- **Demo Credentials**: Ditampilkan di bawah form untuk kemudahan testing

### Register Page (`/register`)
- **Design**: Konsisten dengan login page
- **Elements**: Menggunakan color palette yang sama
- **Animation**: Floating icon effect

## 🏠 Dashboard Theme

### Layout (`layouts/app.blade.php`)
- **Sidebar**: Gradient orange background
- **Navigation**: Orange color scheme
- **Cards**: Orange border dan shadow effects
- **Buttons**: Gradient orange dengan hover animations

## 🎯 Design Elements

### Typography
- **Font Family**: Segoe UI, Tahoma, Geneva, Verdana, sans-serif
- **Headers**: Bold dengan orange color
- **Body Text**: Gray color scheme

### Components
- **Cards**: Rounded corners (15px), orange shadow
- **Buttons**: Gradient background, hover animations
- **Forms**: Orange focus states, rounded inputs
- **Icons**: Font Awesome dengan orange color

### Animations
- **Floating Icons**: Smooth up-down animation
- **Hover Effects**: Transform dan shadow changes
- **Button Press**: Scale dan color transitions

## 📱 Responsive Design

### Mobile First
- **Breakpoints**: Bootstrap 5 standard
- **Sidebar**: Collapsible pada mobile
- **Forms**: Full width pada mobile
- **Cards**: Responsive padding dan margins

### Desktop
- **Layout**: Sidebar + main content
- **Cards**: Hover effects dan animations
- **Navigation**: Dropdown dengan orange theme

## 🔧 CSS Variables

```css
:root {
    --pks-orange: #F0833A;
    --pks-orange-dark: #E67E22;
    --pks-orange-light: #F39C12;
    --pks-orange-lighter: #FDEBD0;
    --pks-gray: #424242;
    --pks-gray-light: #757575;
}
```

## 🎨 Usage Examples

### Button Styling
```css
.btn-primary {
    background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
    border: none;
    border-radius: 8px;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(240, 131, 58, 0.4);
}
```

### Card Styling
```css
.card {
    border: 2px solid rgba(240, 131, 58, 0.1);
    border-radius: 15px;
    box-shadow: 0 4px 20px rgba(240, 131, 58, 0.1);
}
```

### Form Input Styling
```css
.form-control:focus {
    border-color: var(--pks-orange);
    box-shadow: 0 0 0 0.2rem rgba(240, 131, 58, 0.25);
}
```

## 🚀 Demo Credentials

### Admin Access
- **Email**: `admin@bkd.com`
- **Password**: `password123`
- **Access**: Full system access

### User Access
- **Email**: `user@bkd.com`
- **Password**: `password123`
- **Access**: Standard user access

## 📋 Testing Checklist

- [ ] Login page loads with orange theme
- [ ] Register page matches login theme
- [ ] Dashboard uses consistent orange colors
- [ ] All buttons have orange gradient
- [ ] Form inputs have orange focus states
- [ ] Icons use orange color scheme
- [ ] Hover effects work properly
- [ ] Mobile responsive design
- [ ] Demo credentials displayed on login

## 🔄 Future Enhancements

1. **Dark Mode**: Implementasi tema gelap
2. **Custom Logo**: Integrasi logo PKS resmi
3. **Brand Colors**: Penambahan warna brand lainnya
4. **Animation Library**: Library animasi yang lebih kaya
5. **Theme Switcher**: Kemampuan ganti tema

## 📞 Support

Untuk pertanyaan terkait tema atau desain, silakan hubungi tim development.

---

**Last Updated**: {{ date('Y-m-d H:i:s') }}
**Version**: 1.0.0
**Theme**: PKS Orange
