# Fitur Export CSV untuk Statistik Anggota

## Deskripsi
Fitur export CSV telah ditambahkan ke halaman statistik anggota (`/statistik/anggota`) untuk memungkinkan pengguna mengunduh data anggota dalam format CSV yang dapat dibuka di Excel atau aplikasi spreadsheet lainnya.

## Fitur yang Ditambahkan

### 1. Export dengan Filter
- Export dapat dilakukan **sebelum** atau **setelah** menerapkan filter
- Filter yang didukung:
  - Tanggal Mulai dan Tanggal Selesai
  - Jenjang Anggota
  - Status Keanggotaan
  - Jenis Kelamin
  - Rentang Umur (Minimum dan Maksimum)

### 2. Lokasi Tombol Export
- **Header halaman**: Tombol "Export Excel" di sebelah kanan atas
- **Form filter**: Tombol "Export Excel" di bawah tombol "Filter"

### 3. Data yang Diexport
File Excel akan berisi kolom-kolom berikut:
- No
- NIA (Nomor Identitas Anggota)
- Nama Lengkap
- Jenis Kelamin
- Umur
- Jenjang
- Status Keanggotaan
- Email
- No Telepon
- Tempat Lahir
- Tanggal Lahir
- Alamat
- Kota
- Provinsi
- Kode Pos
- DPD
- DPC
- Tanggal Bergabung

### 4. Format File
- **Format**: CSV (.csv) - Dapat dibuka di Excel, Google Sheets, atau aplikasi spreadsheet lainnya
- **Nama file**: `statistik_anggota_YYYY-MM-DD_HH-MM-SS.csv`
- **Jika ada filter**: `statistik_anggota_YYYY-MM-DD_HH-MM-SS_filtered.csv`

### 5. Optimasi Memory
- Menggunakan chunking untuk memproses data dalam batch kecil
- Batasan maksimal 5000 records untuk mencegah memory overflow
- Jika data > 1000 records, otomatis dibatasi ke 1000 records teratas
- Memory limit ditingkatkan ke 512MB untuk export

## Cara Penggunaan

### Export Tanpa Filter
1. Buka halaman `/statistik/anggota`
2. Klik tombol "Export CSV" di header atau di form filter
3. File CSV akan otomatis terdownload

### Export dengan Filter
1. Buka halaman `/statistik/anggota`
2. Isi filter yang diinginkan (tanggal, jenjang, status, dll.)
3. Klik tombol "Filter" untuk melihat hasil
4. Klik tombol "Export CSV" untuk mengunduh data yang sudah difilter

## File yang Dimodifikasi

### Controller
- `app/Http/Controllers/StatistikController.php`
  - Menambahkan method `exportAnggota()`
  - Import `Excel` facade dan `StatistikAnggotaExport`

### Export Class
- `app/Exports/StatistikAnggotaCsvExport.php` (baru)
  - Class untuk handle export CSV
  - Mapping data anggota ke format CSV
  - Chunking untuk optimasi memory

### Route
- `routes/web.php`
  - Menambahkan route `GET /statistik/anggota/export`

### View
- `resources/views/statistik/anggota.blade.php`
  - Menambahkan tombol export di header dan form filter
  - Mengubah icon dari Excel ke CSV

## Testing
Untuk menguji fitur export:
1. Akses `http://127.0.0.1:8000/statistik/anggota`
2. Klik tombol "Export CSV" untuk test export tanpa filter
3. Isi beberapa filter dan klik "Filter"
4. Klik tombol "Export CSV" untuk test export dengan filter
5. Verifikasi file CSV yang didownload berisi data yang benar

## Catatan Teknis
- Export menggunakan library `maatwebsite/excel` dengan format CSV
- Data diambil dengan query yang sama persis dengan halaman statistik
- Filter diterapkan secara konsisten antara tampilan dan export
- Error handling sudah disiapkan untuk menangani masalah export
- Memory optimization dengan chunking dan batasan data
- CSV format lebih ringan dan kompatibel dengan Excel/Google Sheets
