# 🗺️ VISUAL SITEMAP - Sistem Informasi Anggota PKS

## 🎯 Quick Navigation Guide

```
┌─────────────────────────────────────────────────────────────────┐
│                    🏛️ SISTEM INFORMASI ANGGOTA PKS              │
│                         (BKD PD MANAGEMENT)                      │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│                        🔐 PUBLIC ACCESS                          │
├─────────────────────────────────────────────────────────────────┤
│  /login                    → Login Page                         │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│                    🏠 AUTHENTICATED AREA                         │
└─────────────────────────────────────────────────────────────────┘

┌──────────────────────┐
│   📊 DASHBOARD      │
├──────────────────────┤
│  /dashboard          │
│  - Overview Stats    │
│  - Recent Activity   │
│  - Quick Actions     │
└──────────────────────┘
         │
         ├──────────────────────────────────────────────────────────┐
         │                                                           │
         ▼                                                           ▼
┌─────────────────────┐                                   ┌─────────────────────┐
│  👥 KEANGGOTAAN    │                                   │   🔄 MUTASI         │
├─────────────────────┤                                   ├─────────────────────┤
│  /anggota           │                                   │  /mutasi            │
│  ├─ List           │                                   │  ├─ List            │
│  ├─ /create        │                                   │  ├─ /create         │
│  ├─ /{id}          │                                   │  ├─ /{id}           │
│  ├─ /{id}/edit     │                                   │  ├─ /{id}/edit      │
│  ├─ /{id}/print    │                                   │  ├─ /{id}/approve   │
│  ├─ /import        │                                   │  ├─ /{id}/reject    │
│  ├─ /export        │                                   │  ├─ /{id}/print     │
│  └─ /statistik     │                                   │  └─ /export         │
│                     │                                   │                     │
│  SUB: Keanggotaan  │                                   │  🔀 PERPINDAHAN     │
│  /{id}/keanggotaan │                                   │  /perpindahan       │
│  ├─ /show          │                                   │  ├─ List            │
│  ├─ /edit          │                                   │  ├─ /create         │
│  ├─ /history       │                                   │  ├─ /{id}/approve   │
│  └─ /export        │                                   │  └─ /{id}/print     │
└─────────────────────┘                                   └─────────────────────┘
         │                                                           │
         │                                                           │
         ▼                                                           ▼
┌─────────────────────┐                                   ┌─────────────────────┐
│  🏢 MANAJEMEN UPA  │                                   │  📅 KEGIATAN        │
├─────────────────────┤                                   ├─────────────────────┤
│  /upa               │                                   │  /kegiatan          │
│  ├─ List           │                                   │  ├─ List            │
│  ├─ /create        │                                   │  ├─ /create         │
│  ├─ /{id}          │                                   │  ├─ /{id}           │
│  ├─ /{id}/edit     │                                   │  ├─ /{id}/edit      │
│  └─ /delete        │                                   │  ├─ /{id}/absensi   │
│                     │                                   │  └─ /export         │
│  KEGIATAN KELOMPOK │                                   │                     │
│  /upa-group-act..  │                                   │  ✅ CHECK-IN        │
│  ├─ List           │                                   │  /checkin/{id}      │
│  ├─ /create        │                                   │  ├─ QR Scanner      │
│  ├─ /{id}          │                                   │  ├─ Manual Entry    │
│  └─ /{id}/edit     │                                   │  └─ /stats          │
│                     │                                   │                     │
│  AGENDA MASTER     │                                   │  📚 TAKWIM          │
│  /upa-agenda-mas.. │                                   │  /takwim            │
│  ├─ List           │                                   │  ├─ List            │
│  ├─ /create        │                                   │  ├─ /create         │
│  ├─ /{id}          │                                   │  ├─ /{id}           │
│  └─ /toggle-status │                                   │  ├─ /{id}/edit      │
│                     │                                   │  ├─ /add-peserta   │
│  REKOMPOSISI       │                                   │  └─ /remove-peserta │
│  /rekomposisi-upa  │                                   │                     │
│  ├─ List           │                                   │  🎯 PENILAIAN       │
│  ├─ /create        │                                   │  /penilaian-peserta │
│  ├─ /{id}          │                                   │  ├─ List (Admin)    │
│  ├─ /{id}/approve  │                                   │  ├─ /create         │
│  ├─ /{id}/publish  │                                   │  ├─ /{id}/edit      │
│  └─ /{id}/pdf      │                                   │  └─ /laporan        │
│                     │                                   │                     │
│  SURAT PENEMPATAN  │                                   └─────────────────────┘
│  /surat-penempatan │
│  ├─ List           │
│  ├─ /create        │
│  └─ /generate-pdf  │
└─────────────────────┘
         │
         ├──────────────────────────────────────────────────────────┐
         │                                                           │
         ▼                                                           ▼
┌─────────────────────┐                                   ┌─────────────────────┐
│  📝 YAUMIYAH       │                                   │  📊 MASTER DATA     │
├─────────────────────┤                                   ├─────────────────────┤
│  /yaumiyah          │                                   │  JENIS KEGIATAN     │
│  ├─ Dashboard      │                                   │  /jenis-kegiatan    │
│  ├─ /records       │                                   │  ├─ List            │
│  ├─ /records-list  │                                   │  ├─ /create         │
│  ├─ /reports       │                                   │  └─ /{id}/edit      │
│  └─ /activities    │                                   │                     │
│     ├─ List        │                                   │  KEAHLIAN           │
│     ├─ /create     │                                   │  /keahlian          │
│     ├─ /{id}       │                                   │  ├─ List            │
│     └─ /{id}/edit  │                                   │  ├─ /create         │
│                     │                                   │  └─ /{id}/edit      │
│  API YAUMIYAH      │                                   │                     │
│  /api/yaumiyah     │                                   │  INDIKATOR TAKWIM   │
│  ├─ /activities    │                                   │  /indikator-takwim  │
│  ├─ /records       │                                   │  ├─ List            │
│  └─ POST /records  │                                   │  ├─ /create         │
└─────────────────────┘                                   │  └─ /{id}/edit      │
                                                           │                     │
                                                           │  AKTIVITAS LUAR     │
                                                           │  /aktivitas-luar    │
                                                           │  ├─ List            │
                                                           │  ├─ /create         │
                                                           │  └─ /{id}/edit      │
                                                           └─────────────────────┘
         │
         ├──────────────────────────────────────────────────────────┐
         │                                                           │
         ▼                                                           ▼
┌─────────────────────┐                                   ┌─────────────────────┐
│  📈 STATISTIK      │                                   │  📄 LAPORAN         │
├─────────────────────┤                                   ├─────────────────────┤
│  /statistik         │                                   │  /laporan           │
│  ├─ Dashboard      │                                   │  ├─ Dashboard       │
│  ├─ /anggota       │                                   │  ├─ /anggota        │
│  ├─ /kegiatan      │                                   │  ├─ /mutasi         │
│  ├─ /mutasi        │                                   │  ├─ /kegiatan       │
│  └─ /takwim        │                                   │  ├─ /kehadiran      │
│                     │                                   │  └─ /takwim         │
│  📊 Charts & Graphs│                                   │                     │
│  - Demografi       │                                   │  📥 EXPORT          │
│  - Trend Analysis  │                                   │  ├─ /export/anggota │
│  - Performance     │                                   │  ├─ /export/mutasi  │
└─────────────────────┘                                   │  └─ /export/kegiatan│
                                                           └─────────────────────┘
         │
         ├──────────────────────────────────────────────────────────┐
         │                                                           │
         ▼                                                           ▼
┌─────────────────────┐                                   ┌─────────────────────┐
│  👤 USER MGMT      │                                   │  ⚙️ PENGATURAN      │
│  (Admin Only)       │                                   ├─────────────────────┤
├─────────────────────┤                                   │  POST /logout       │
│  /user-management   │                                   │  POST /change-pwd   │
│  ├─ List           │                                   │                     │
│  ├─ /create        │                                   │  👤 Profile         │
│  ├─ /{id}          │                                   │  - View Profile     │
│  ├─ /{id}/edit     │                                   │  - Update Info      │
│  └─ /toggle-status │                                   │  - Change Password  │
│                     │                                   │  - Logout           │
│  🔑 Roles:         │                                   └─────────────────────┘
│  - Superadmin      │
│  - Admin           │
│  - User            │
└─────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│                        📱 MOBILE INTERFACE                       │
├─────────────────────────────────────────────────────────────────┤
│  /mobile                    → Mobile Dashboard                  │
│  /mobile/attendance         → Kegiatan & Absensi                │
│  /mobile/mutasi             → Pengajuan Mutasi                  │
│  /mobile/profile            → Profil Anggota                    │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│                          🔌 API ENDPOINTS                        │
├─────────────────────────────────────────────────────────────────┤
│  ALAMAT API                                                      │
│  /api/provinsi              → List Provinsi                     │
│  /api/kota                  → List Kota by Provinsi             │
│  /api/kecamatan             → List Kecamatan by Kota            │
│  /api/kelurahan             → List Kelurahan by Kecamatan       │
│                                                                  │
│  ORGANISASI API                                                  │
│  /api/dpc-by-dpd/{id}       → DPC by DPD                        │
│  /api/upa-by-dpc/{id}       → UPA by DPC                        │
│  /api/struktur-organisasi   → All Struktur                      │
│                                                                  │
│  ANGGOTA API                                                     │
│  /api/anggota/search        → Search Anggota                    │
│  /api/anggota-paginated     → Paginated Anggota                 │
│  /api/anggota-upa           → Anggota by UPA                    │
│                                                                  │
│  YAUMIYAH API                                                    │
│  /api/yaumiyah/activities   → Master Activities                 │
│  /api/yaumiyah/records      → Get Records                       │
│  POST /api/yaumiyah/records → Submit Records                    │
└─────────────────────────────────────────────────────────────────┘
```

---

## 🎯 ROLE-BASED ACCESS

```
┌────────────────────────────────────────────────────────┐
│                  🔴 SUPERADMIN                          │
├────────────────────────────────────────────────────────┤
│  ✅ Full Access to ALL Features                        │
│  ✅ User Management                                     │
│  ✅ System Configuration                                │
│  ✅ All Approvals                                       │
│  ✅ All Reports & Exports                               │
│  ✅ Penilaian Peserta Takwim                           │
└────────────────────────────────────────────────────────┘

┌────────────────────────────────────────────────────────┐
│                    🟡 ADMIN                             │
├────────────────────────────────────────────────────────┤
│  ✅ Manajemen Anggota (Full)                           │
│  ✅ Manajemen Kegiatan (Full)                          │
│  ✅ Manajemen UPA (Full)                               │
│  ✅ Approval Mutasi & Perpindahan                      │
│  ✅ Penilaian Peserta Takwim                           │
│  ✅ Most Reports & Exports                             │
│  ❌ User Management (Limited)                          │
│  ❌ System Configuration                               │
└────────────────────────────────────────────────────────┘

┌────────────────────────────────────────────────────────┐
│                    🟢 USER                              │
├────────────────────────────────────────────────────────┤
│  ✅ View Anggota (Read-only)                           │
│  ✅ View Kegiatan                                       │
│  ✅ Check-in Kegiatan                                   │
│  ✅ Submit Mutasi (self)                               │
│  ✅ Yaumiyah Recording                                  │
│  ✅ View Basic Reports                                  │
│  ❌ No Approval Rights                                  │
│  ❌ No Delete/Edit Others                              │
│  ❌ No User Management                                  │
└────────────────────────────────────────────────────────┘
```

---

## 📊 DATA FLOW DIAGRAM

```
┌──────────────┐
│   LOGIN      │
└──────┬───────┘
       │
       ▼
┌──────────────┐         ┌─────────────────┐
│  DASHBOARD   │────────▶│  QUICK ACTIONS  │
└──────┬───────┘         └─────────────────┘
       │
       ├────────────────────┬─────────────────┬────────────────┐
       ▼                    ▼                 ▼                ▼
┌──────────────┐    ┌──────────────┐  ┌──────────────┐  ┌──────────────┐
│   ANGGOTA    │    │    MUTASI    │  │   KEGIATAN   │  │     UPA      │
│              │    │              │  │              │  │              │
│ ┌──────────┐ │    │ ┌──────────┐ │  │ ┌──────────┐ │  │ ┌──────────┐ │
│ │  Create  │ │    │ │  Submit  │ │  │ │  Create  │ │  │ │  Create  │ │
│ └──────────┘ │    │ └──────────┘ │  │ └──────────┘ │  │ └──────────┘ │
│              │    │       │      │  │       │      │  │              │
│ ┌──────────┐ │    │       ▼      │  │       ▼      │  │ ┌──────────┐ │
│ │   View   │ │    │ ┌──────────┐ │  │ ┌──────────┐ │  │ │   View   │ │
│ └──────────┘ │    │ │ Approve/ │ │  │ │ Check-in │ │  │ └──────────┘ │
│              │    │ │  Reject  │ │  │ └──────────┘ │  │              │
│ ┌──────────┐ │    │ └──────────┘ │  │       │      │  │ ┌──────────┐ │
│ │   Edit   │ │    │       │      │  │       ▼      │  │ │Rekomposisi│ │
│ └──────────┘ │    │       ▼      │  │ ┌──────────┐ │  │ └──────────┘ │
│              │    │ ┌──────────┐ │  │ │  Absensi │ │  │       │      │
│ ┌──────────┐ │    │ │  Print   │ │  │ └──────────┘ │  │       ▼      │
│ │ Import/  │ │    │ │  Surat   │ │  │              │  │ ┌──────────┐ │
│ │  Export  │ │    │ └──────────┘ │  │ ┌──────────┐ │  │ │  Surat   │ │
│ └──────────┘ │    │              │  │ │  Report  │ │  │ │Penempatan│ │
│              │    └──────────────┘  │ └──────────┘ │  │ └──────────┘ │
└──────┬───────┘                      └──────┬───────┘  └──────┬───────┘
       │                                     │                 │
       └────────────────┬────────────────────┴─────────────────┘
                        ▼
              ┌──────────────────┐
              │  REPORTS & STATS │
              │                  │
              │  ┌────────────┐  │
              │  │  Laporan   │  │
              │  └────────────┘  │
              │                  │
              │  ┌────────────┐  │
              │  │ Statistik  │  │
              │  └────────────┘  │
              │                  │
              │  ┌────────────┐  │
              │  │   Export   │  │
              │  └────────────┘  │
              └──────────────────┘
```

---

## 🔄 WORKFLOW DIAGRAM

### Alur Pengajuan Mutasi
```
┌───────────┐      ┌───────────┐      ┌───────────┐      ┌───────────┐
│  Anggota  │      │   Admin   │      │ Approval  │      │   Print   │
│  Submit   │─────▶│  Verify   │─────▶│ Process   │─────▶│   Surat   │
│  Mutasi   │      │   Data    │      │           │      │   Mutasi  │
└───────────┘      └───────────┘      └───────────┘      └───────────┘
     │                    │                  │                  │
     │                    │                  ▼                  │
     │                    │            ┌───────────┐            │
     │                    │            │ Approved/ │            │
     │                    │            │ Rejected  │            │
     │                    │            └───────────┘            │
     │                    │                  │                  │
     │                    │                  ▼                  │
     │                    │            ┌───────────┐            │
     │                    │            │  Update   │            │
     │                    │            │  Status   │            │
     │                    │            └───────────┘            │
     │                    │                  │                  │
     └────────────────────┴──────────────────┴──────────────────┘
                                        │
                                        ▼
                                 ┌───────────┐
                                 │Notification│
                                 │to Anggota │
                                 └───────────┘
```

### Alur Rekomposisi UPA
```
┌───────────┐      ┌───────────┐      ┌───────────┐      ┌───────────┐
│   Create  │      │  Select   │      │ Approval  │      │  Publish  │
│Rekomposisi│─────▶│  Anggota  │─────▶│           │─────▶│    SK     │
│    UPA    │      │& Pembimbing│      │           │      │           │
└───────────┘      └───────────┘      └───────────┘      └───────────┘
                          │                  │                  │
                          ▼                  ▼                  ▼
                   ┌───────────┐      ┌───────────┐      ┌───────────┐
                   │  Validate │      │  Review   │      │Update UPA │
                   │   Data    │      │& Approve  │      │  Members  │
                   └───────────┘      └───────────┘      └───────────┘
```

### Alur Absensi Kegiatan
```
┌───────────┐      ┌───────────┐      ┌───────────┐      ┌───────────┐
│  Create   │      │ Generate  │      │ Check-in  │      │  Report   │
│ Kegiatan  │─────▶│  QR Code  │─────▶│  Anggota  │─────▶│  Absensi  │
└───────────┘      └───────────┘      └───────────┘      └───────────┘
                          │                  │                  │
                          │                  ▼                  │
                          │            ┌───────────┐            │
                          │            │   Scan    │            │
                          │            │ QR / Manual│           │
                          │            └───────────┘            │
                          │                  │                  │
                          │                  ▼                  │
                          │            ┌───────────┐            │
                          │            │  Update   │            │
                          │            │Real-time  │            │
                          │            └───────────┘            │
                          │                  │                  │
                          └──────────────────┴──────────────────┘
```

---

## 🎨 NAVIGATION HIERARCHY

```
📱 TOP NAVIGATION BAR
├── 🏢 PKS Logo
├── 🔍 Global Search
├── 🔔 Notifications
└── 👤 User Menu
    ├── Profile
    ├── Settings
    ├── Change Password
    └── Logout

📊 SIDEBAR MENU (Main Navigation)
│
├── 📊 Dashboard
│
├── 👥 KEANGGOTAAN
│   ├── 👤 Data Anggota
│   ├── 📥 Import Anggota
│   ├── 📊 Statistik Anggota
│   └── 📄 Laporan Anggota
│
├── 🔄 MUTASI & PERPINDAHAN
│   ├── 🔄 Mutasi Anggota
│   ├── 🔀 Perpindahan Anggota (Legacy)
│   ├── 🔀 Perpindahan Anggota (Unified System)
│   └── 📄 Laporan Mutasi
│
├── 🏢 MANAJEMEN DPC
│   ├── 🏢 Data DPC
│   ├── 📊 Statistik DPC
│   └── ⚙️ Toggle Status DPC
│
├── 🏢 MANAJEMEN UPA
│   ├── 🏢 Data UPA
│   ├── 📋 Kegiatan Kelompok UPA
│   ├── 📝 Agenda Master UPA
│   ├── 🔄 Rekomposisi UPA
│   └── 📄 Surat Penempatan UPA
│
├── 📅 KEGIATAN & PROGRAM
│   ├── 📅 Data Kegiatan
│   ├── ✅ Absensi & Check-in
│   ├── 📚 Takwim (Kaderisasi)
│   ├── 🎯 Penilaian Peserta [Admin]
│   └── 📄 Laporan Kegiatan
│
├── 📝 YAUMIYAH
│   ├── 📊 Dashboard Yaumiyah
│   ├── ✍️ Pencatatan Aktivitas
│   ├── 📋 Master Aktivitas
│   ├── 📜 Riwayat Pencatatan
│   └── 📊 Laporan Yaumiyah
│
├── 📊 MASTER DATA
│   ├── 🏢 Data DPC
│   ├── 🎯 Jenis Kegiatan
│   ├── 💼 Keahlian
│   ├── 📊 Indikator Takwim
│   └── 🌐 Aktivitas Luar
│
├── 📈 STATISTIK & LAPORAN
│   ├── 📊 Statistik Anggota
│   ├── 📊 Statistik Kegiatan
│   ├── 📊 Statistik Mutasi
│   ├── 📊 Statistik Takwim
│   └── 📄 Semua Laporan
│
├── 👤 USER MANAGEMENT [Admin Only]
│   ├── 👥 Kelola User
│   ├── 🔑 Role & Permission
│   └── 🔒 User Status
│
└── ⚙️ PENGATURAN
    ├── 👤 Profil Saya
    ├── 🔒 Ganti Password
    └── 🚪 Logout
```

---

## 🚀 QUICK ACCESS CHECKLIST

### ✅ For Project Owner - Testing Checklist

1. **Authentication**
   - [ ] Login with superadmin credentials
   - [ ] Login with admin credentials
   - [ ] Login with user credentials
   - [ ] Test logout functionality
   - [ ] Test change password

2. **Anggota Management**
   - [ ] View list anggota
   - [ ] Add new anggota
   - [ ] Edit anggota data
   - [ ] View anggota detail
   - [ ] Import anggota from Excel
   - [ ] Export anggota to Excel
   - [ ] Print kartu anggota

3. **Mutasi & Perpindahan**
   - [ ] Submit mutasi request
   - [ ] Approve/reject mutasi
   - [ ] Print surat mutasi
   - [ ] View mutasi history
   - [ ] Export mutasi data

4. **UPA Management**
   - [ ] Create new UPA
   - [ ] View UPA details
   - [ ] Create UPA group activity
   - [ ] Create agenda master
   - [ ] Submit rekomposisi UPA
   - [ ] Generate surat penempatan

5. **Kegiatan & Absensi**
   - [ ] Create new kegiatan
   - [ ] Generate QR code for check-in
   - [ ] Test check-in with QR code
   - [ ] Manual check-in
   - [ ] View attendance report

6. **Takwim & Penilaian**
   - [ ] Create takwim program
   - [ ] Add peserta to takwim
   - [ ] Input penilaian peserta
   - [ ] View laporan penilaian

7. **Yaumiyah**
   - [ ] Create master activities
   - [ ] Record daily activities
   - [ ] View activity history
   - [ ] Generate yaumiyah report

8. **Reports & Statistics**
   - [ ] View dashboard statistics
   - [ ] Generate anggota report
   - [ ] Generate kegiatan report
   - [ ] Generate mutasi report
   - [ ] Export reports to Excel/PDF

9. **User Management (Admin)**
   - [ ] Create new user
   - [ ] Assign roles
   - [ ] Toggle user status
   - [ ] Edit user permissions

10. **Mobile Interface**
    - [ ] Access mobile dashboard
    - [ ] Mobile attendance check-in
    - [ ] Mobile mutasi submission
    - [ ] Mobile profile view

---

## 📞 SUPPORT & DOCUMENTATION

### 📚 Full Documentation Links
- 📋 [SITEMAP.md](SITEMAP.md) - Detail sitemap lengkap
- 📖 [README.md](README.md) - Project overview
- 🚀 [FEATURES.md](FEATURES.md) - Feature documentation
- 🗄️ [DATABASE_SCHEMA.md](DATABASE_SCHEMA.md) - Database structure
- 🔌 [API_DOCUMENTATION.md](API_DOCUMENTATION.md) - API reference
- 🚀 [DEPLOYMENT.md](DEPLOYMENT.md) - Deployment guide

### 🎯 Quick Start URLs (Development)
```
Login:      http://localhost:8000/login
Dashboard:  http://localhost:8000/dashboard
Anggota:    http://localhost:8000/anggota
Mutasi:     http://localhost:8000/mutasi
Kegiatan:   http://localhost:8000/kegiatan
UPA:        http://localhost:8000/upa
Takwim:     http://localhost:8000/takwim
Yaumiyah:   http://localhost:8000/yaumiyah
Laporan:    http://localhost:8000/laporan
```

### 🔑 Default Credentials
```
Superadmin: superadmin@bkd.com / password123
Admin:      admin@bkd.com / password123
User:       user@bkd.com / password123
```

---

**📱 Responsive Design**: Semua halaman optimized untuk Desktop, Tablet, dan Mobile
**🔒 Security**: Role-based access control & data encryption
**⚡ Performance**: Optimized queries & caching system

---

**© 2025 BKD PD - Sistem Informasi Anggota PKS**
**Dibuat dengan ❤️ untuk Partai Keadilan Sejahtera**

