# 🗺️ SITEMAP - Sistem Informasi Anggota PKS (BKD PD)

## 📋 Overview
Dokumen ini menyediakan sitemap lengkap aplikasi Sistem Informasi Anggota PKS untuk memudahkan navigasi dan pemahaman struktur aplikasi.

---

## 🔐 PUBLIC PAGES (Tidak Perlu Login)

### Authentication
- **`/login`** - Halaman Login
  - Form login dengan email/password
  - Opsi "Remember Me"

---

## 🏠 AUTHENTICATED PAGES (Perlu Login)

### 1. 📊 DASHBOARD
- **`/`** atau **`/dashboard`** - Dashboard Utama
  - Overview statistik anggota
  - Grafik dan chart interaktif
  - Recent activities
  - Quick actions

---

### 2. 👥 MANAJEMEN ANGGOTA

#### 2.1 CRUD Anggota
- **`/anggota`** - List Anggota (dengan pencarian & filter)
  - Tabel data anggota
  - Pencarian real-time
  - Filter berdasarkan jenjang, status, DPC, DPD
  - Pagination

- **`/anggota/create`** - Tambah Anggota Baru
  - Form lengkap data anggota
  - Upload foto profil
  - Dropdown cascading (DPD > DPC > UPA)

- **`/anggota/{anggota}`** - Detail Anggota
  - Informasi lengkap anggota
  - Foto profil
  - Riwayat mutasi
  - Riwayat kegiatan
  - Tab navigasi (Detail, Keanggotaan, Riwayat)

- **`/anggota/{anggota}/edit`** - Edit Data Anggota
  - Form edit data anggota
  - Update foto profil
  - Validasi real-time

- **`/anggota/{anggota}/print`** - Cetak Kartu Anggota (PDF)

#### 2.2 Keanggotaan Anggota
- **`/anggota/{anggota}/keanggotaan`** - Detail Keanggotaan
  - Status keanggotaan
  - Jenjang anggota
  - UPA assignment
  - DPC assignment

- **`/anggota/{anggota}/keanggotaan/edit`** - Edit Keanggotaan
  - Update jenjang
  - Update UPA
  - Update DPC
  - Catatan perubahan

- **`/anggota/{anggota}/keanggotaan/history`** - Riwayat Keanggotaan (JSON)
  - History perubahan jenjang
  - History perpindahan UPA
  - Timeline perubahan

- **`/anggota/{anggota}/keanggotaan/export`** - Export Riwayat (Excel)

#### 2.3 Import/Export Anggota
- **`/anggota/import`** - Halaman Import Anggota
  - Upload file Excel
  - Download template import
  - Preview data import
  - Validasi data

- **`/anggota/export`** - Export Data Anggota (Excel)
  - Filter data sebelum export
  - Pilihan kolom yang di-export

#### 2.4 Statistik Anggota
- **`/anggota/statistik`** - Statistik Data Anggota
  - Grafik demografi
  - Statistik per jenjang
  - Statistik per DPC/DPD
  - Trend keanggotaan

---

### 3. 🔄 MANAJEMEN MUTASI

#### 3.1 CRUD Mutasi
- **`/mutasi`** - List Mutasi
  - Tabel data mutasi
  - Filter berdasarkan status
  - Pencarian anggota
  - Status tracking

- **`/mutasi/create`** - Pengajuan Mutasi Baru
  - Form pengajuan mutasi
  - Auto-populate data anggota
  - Pilih DPC/DPD tujuan
  - Upload dokumen pendukung

- **`/mutasi/{mutasi}`** - Detail Mutasi
  - Informasi lengkap mutasi
  - Data anggota
  - Status approval
  - Timeline mutasi

- **`/mutasi/{mutasi}/edit`** - Edit Mutasi
  - Form edit mutasi
  - Update data mutasi

#### 3.2 Approval Mutasi
- **`POST /mutasi/{mutasi}/approve`** - Approve Mutasi
  - Konfirmasi approval
  - Generate nomor SK
  - Update status anggota

- **`POST /mutasi/{mutasi}/reject`** - Reject Mutasi
  - Konfirmasi penolakan
  - Alasan penolakan
  - Notifikasi ke pengaju

#### 3.3 Dokumen Mutasi
- **`/mutasi/{mutasi}/print-surat`** - Cetak Surat Mutasi (PDF)
  - Surat mutasi resmi
  - Digital signature
  - Nomor SK

- **`/mutasi/export`** - Export Data Mutasi (Excel)

---

### 4. 🔀 MANAJEMEN PERPINDAHAN

#### 4.1 CRUD Perpindahan
- **`/perpindahan`** - List Perpindahan
  - Tabel data perpindahan anggota
  - Filter dan pencarian
  - Status tracking

- **`/perpindahan/create`** - Buat Perpindahan Baru
  - Form perpindahan anggota
  - Pilih anggota dan tujuan

- **`/perpindahan/{perpindahan}`** - Detail Perpindahan

- **`/perpindahan/{perpindahan}/edit`** - Edit Perpindahan

#### 4.2 Approval Perpindahan
- **`POST /perpindahan/{perpindahan}/approve`** - Approve Perpindahan
- **`POST /perpindahan/{perpindahan}/reject`** - Reject Perpindahan

#### 4.3 Dokumen Perpindahan
- **`/perpindahan/print/surat-resmi`** - Cetak Surat Resmi (PDF)
- **`/perpindahan/{perpindahan}/print/surat-penempatan`** - Cetak Surat Penempatan (PDF)

---

### 5. 🔀 PERPINDAHAN ANGGOTA (UNIFIED SYSTEM)

#### 5.1 CRUD Perpindahan Anggota
- **`/perpindahan-anggota`** - List Perpindahan Anggota
  - Tabel data perpindahan terintegrasi
  - Filter dan pencarian advanced
  - Status tracking real-time

- **`/perpindahan-anggota/create`** - Buat Perpindahan Anggota Baru
  - Form perpindahan lengkap
  - Pilih DPC asal dan tujuan
  - Pilih UPA asal dan tujuan
  - Pilih anggota dari UPA
  - Pilih pembimbing baru
  - Auto-populate data

- **`/perpindahan-anggota/{perpindahanAnggota}`** - Detail Perpindahan
  - Informasi lengkap perpindahan
  - Data anggota yang dipindahkan
  - UPA asal dan tujuan
  - Pembimbing lama dan baru
  - Timeline perpindahan

- **`/perpindahan-anggota/{perpindahanAnggota}/edit`** - Edit Perpindahan

#### 5.2 Dokumen Perpindahan Anggota
- **`/perpindahan-anggota/{perpindahanAnggota}/download-surat`** - Download Surat Perpindahan (PDF)
  - Surat perpindahan resmi
  - Informasi lengkap perpindahan
  - Digital signature

#### 5.3 AJAX API Perpindahan Anggota
- **`/perpindahan-anggota-ajax/upa-by-dpc`** - Get UPA by DPC (JSON)
- **`/perpindahan-anggota-ajax/anggota-by-upa`** - Get Anggota by UPA (JSON)
- **`/perpindahan-anggota-ajax/pembimbing-by-upa`** - Get Pembimbing by UPA (JSON)

---

### 6. 🏢 MANAJEMEN DPC

#### 6.1 CRUD DPC (Dewan Pimpinan Cabang)
- **`/dpc`** - List DPC
  - Tabel data DPC
  - Filter berdasarkan DPD
  - Status DPC (Aktif/Nonaktif)
  - Jumlah anggota per DPC
  - Jumlah UPA per DPC

- **`/dpc/create`** - Tambah DPC Baru
  - Form DPC lengkap
  - Nama DPC
  - Kode DPC
  - DPD parent
  - Alamat lengkap
  - Kontak DPC
  - Status

- **`/dpc/{dpc}`** - Detail DPC
  - Informasi lengkap DPC
  - List UPA di bawah DPC
  - List anggota di DPC
  - Statistik DPC
  - Struktur kepengurusan

- **`/dpc/{dpc}/edit`** - Edit DPC
  - Update data DPC
  - Update status
  - Update kontak

#### 6.2 DPC Actions
- **`POST /dpc/{dpc}/toggle-status`** - Aktifkan/Nonaktifkan DPC
  - Toggle status aktif/nonaktif
  - Confirmation dialog
  - Update status anggota terkait

---

### 7. 📅 MANAJEMEN KEGIATAN

#### 7.1 CRUD Kegiatan
- **`/kegiatan`** - List Kegiatan
  - Tabel data kegiatan
  - Filter berdasarkan jenis & status
  - Calendar view

- **`/kegiatan/create`** - Tambah Kegiatan Baru
  - Form kegiatan lengkap
  - Pilih jenis kegiatan
  - Tentukan lokasi & tanggal
  - Tambah partisipan

- **`/kegiatan/{kegiatan}`** - Detail Kegiatan
  - Informasi kegiatan
  - List partisipan
  - Data absensi
  - Statistik kehadiran

- **`/kegiatan/{kegiatan}/edit`** - Edit Kegiatan

#### 7.2 Absensi Kegiatan
- **`/kegiatan/{kegiatan}/absensi`** - Halaman Absensi
  - Check-in/Check-out
  - Daftar hadir
  - Status kehadiran
  - Generate QR code

- **`POST /kegiatan/{kegiatan}/update-kehadiran`** - Update Status Kehadiran

#### 7.3 Check-in Sistem (QR Code)
- **`/checkin/{kegiatanId}`** - Halaman Check-in Publik
  - QR code scanner
  - Manual check-in
  - Real-time statistics

- **`POST /checkin/{kegiatanId}/checkin`** - Proses Check-in
- **`/checkin/{kegiatanId}/stats`** - Statistik Check-in (JSON)
- **`/checkin/{kegiatanId}/qr`** - Generate QR Code

#### 7.4 Export Kegiatan
- **`/kegiatan/export`** - Export Data Kegiatan (Excel)

---

### 8. 📚 MANAJEMEN TAKWIM

#### 8.1 CRUD Takwim
- **`/takwim`** - List Takwim (Program Kaderisasi)
  - Tabel data takwim
  - Filter berdasarkan periode
  - Status program

- **`/takwim/create`** - Tambah Takwim Baru
  - Form takwim lengkap
  - Tentukan indikator penilaian
  - Tambah peserta

- **`/takwim/{takwim}`** - Detail Takwim
  - Informasi takwim
  - List peserta
  - Penilaian peserta
  - Progress tracking

- **`/takwim/{takwim}/edit`** - Edit Takwim

#### 8.2 Peserta Takwim
- **`POST /takwim/{takwim}/peserta`** - Tambah Peserta Takwim
- **`DELETE /takwim/{takwim}/peserta/{anggota}`** - Hapus Peserta

---

### 9. 🎯 PENILAIAN PESERTA TAKWIM (Admin Only)

- **`/penilaian-peserta`** - List Penilaian
  - Tabel penilaian peserta
  - Filter berdasarkan takwim

- **`/penilaian-peserta/create`** - Tambah Penilaian
  - Form penilaian peserta
  - Pilih peserta & indikator
  - Input nilai

- **`/penilaian-peserta/{penilaian}`** - Detail Penilaian

- **`/penilaian-peserta/{penilaian}/edit`** - Edit Penilaian

- **`/penilaian-peserta/laporan`** - Laporan Penilaian
  - Ranking peserta
  - Analisis nilai
  - Export hasil

---

### 10. 🏢 MANAJEMEN UPA

#### 10.1 CRUD UPA
- **`/upa`** - List UPA (Unit Pembinaan Anggota)
  - Tabel data UPA
  - Filter berdasarkan DPC
  - Status UPA

- **`/upa/create`** - Tambah UPA Baru
  - Form UPA lengkap
  - Alamat lengkap dengan cascading dropdown
  - Kode UPA otomatis

- **`/upa/{upa}`** - Detail UPA
  - Informasi UPA
  - List anggota UPA
  - Pembimbing UPA
  - Statistik UPA

- **`/upa/{upa}/edit`** - Edit UPA

---

### 11. 📋 UPA GROUP ACTIVITY

#### 11.1 CRUD UPA Group Activity
- **`/upa-group-activity`** - List Kegiatan Kelompok UPA
  - Tabel kegiatan kelompok
  - Filter berdasarkan UPA

- **`/upa-group-activity/create`** - Tambah Kegiatan Kelompok Baru
  - Form kegiatan kelompok
  - Pilih UPA
  - Tambah partisipan dari UPA
  - Absensi otomatis

- **`/upa-group-activity/{upaGroupActivity}`** - Detail Kegiatan Kelompok
  - Informasi kegiatan
  - List partisipan
  - Absensi
  - Statistik

- **`/upa-group-activity/{upaGroupActivity}/edit`** - Edit Kegiatan Kelompok

---

### 12. 📝 UPA AGENDA MASTER

#### 12.1 CRUD UPA Agenda Master
- **`/upa-agenda-master`** - List Agenda Master UPA
  - Template agenda kegiatan UPA
  - Status aktif/nonaktif

- **`/upa-agenda-master/create`** - Tambah Agenda Master Baru
  - Form agenda template
  - Jenis kegiatan
  - Frekuensi kegiatan

- **`/upa-agenda-master/{upaAgendaMaster}`** - Detail Agenda Master

- **`/upa-agenda-master/{upaAgendaMaster}/edit`** - Edit Agenda Master

- **`POST /upa-agenda-master/{upaAgendaMaster}/toggle-status`** - Aktifkan/Nonaktifkan Agenda

---

### 13. 🔄 REKOMPOSISI UPA

#### 13.1 CRUD Rekomposisi UPA
- **`/rekomposisi-upa`** - List Rekomposisi UPA
  - Tabel rekomposisi
  - Status approval
  - Periode rekomposisi

- **`/rekomposisi-upa/create`** - Buat Rekomposisi Baru
  - Form rekomposisi UPA
  - Pilih DPC
  - Tambah anggota baru ke UPA
  - Pilih pembimbing

- **`/rekomposisi-upa/{rekomposisiUpa}`** - Detail Rekomposisi
  - Data rekomposisi
  - List anggota
  - Status approval

- **`/rekomposisi-upa/{rekomposisiUpa}/edit`** - Edit Rekomposisi

#### 13.2 Approval & Dokumen
- **`POST /rekomposisi-upa/{rekomposisiUpa}/approve`** - Approve Rekomposisi
- **`POST /rekomposisi-upa/{rekomposisiUpa}/publish`** - Publish Rekomposisi
- **`/rekomposisi-upa/{rekomposisiUpa}/pdf`** - Download PDF
- **`/rekomposisi-upa/{rekomposisiUpa}/print`** - Cetak SK

---

### 14. 📄 SURAT PENEMPATAN UPA

- **`/surat-penempatan`** - List Surat Penempatan
  - Riwayat surat penempatan

- **`/surat-penempatan/create`** - Buat Surat Penempatan Baru
  - Form surat penempatan
  - Pilih anggota
  - Pilih UPA tujuan
  - Pilih pembimbing

- **`POST /surat-penempatan/generate`** - Generate Surat (Preview)
- **`POST /surat-penempatan/generate-pdf`** - Generate Surat (PDF)

---

### 15. 📝 YAUMIYAH (Aktivitas Harian)

#### 15.1 Dashboard Yaumiyah
- **`/yaumiyah`** - Dashboard Yaumiyah
  - Overview aktivitas harian
  - Statistik pencapaian

#### 15.2 Master Activities
- **`/yaumiyah/activities`** - List Master Aktivitas
  - Daftar jenis aktivitas yaumiyah
  
- **`/yaumiyah/activities/create`** - Tambah Aktivitas Baru

- **`/yaumiyah/activities/{activity}`** - Detail Aktivitas

- **`/yaumiyah/activities/{activity}/edit`** - Edit Aktivitas

#### 15.3 Records (Pencatatan)
- **`/yaumiyah/records`** - Form Pencatatan Yaumiyah
  - Input aktivitas harian
  - Multi-select aktivitas
  - Tanggal dan catatan

- **`POST /yaumiyah/records`** - Submit Pencatatan

- **`/yaumiyah/records-list`** - List Pencatatan
  - Riwayat pencatatan
  - Filter berdasarkan tanggal

- **`/yaumiyah/records-detail`** - Detail Pencatatan (JSON)

#### 15.4 Reports
- **`/yaumiyah/reports`** - Laporan Yaumiyah
  - Statistik aktivitas
  - Grafik pencapaian
  - Export laporan

---

### 16. 📊 STATISTIK

- **`/statistik`** - Halaman Statistik Utama
  - Overview statistik sistem
  - Grafik dan charts

- **`/statistik/anggota`** - Statistik Anggota
  - Demografi anggota
  - Statistik per jenjang
  - Trend keanggotaan

- **`/statistik/kegiatan`** - Statistik Kegiatan
  - Jumlah kegiatan per periode
  - Tingkat partisipasi
  - Trend kehadiran

- **`/statistik/mutasi`** - Statistik Mutasi
  - Trend mutasi
  - Perpindahan antar DPC
  - Status approval

- **`/statistik/takwim`** - Statistik Takwim
  - Progress program kaderisasi
  - Penilaian peserta
  - Completion rate

---

### 17. 📈 LAPORAN

#### 17.1 Index Laporan
- **`/laporan`** - Dashboard Laporan
  - Akses ke semua jenis laporan
  - Quick links

#### 17.2 Laporan Anggota
- **`/laporan/anggota`** - Laporan Data Anggota
  - Filter laporan
  - Preview laporan
  
- **`/laporan/export/anggota`** - Export Laporan Anggota (Excel/PDF)

#### 17.3 Laporan Mutasi
- **`/laporan/mutasi`** - Laporan Mutasi
  - Data mutasi per periode
  - Status approval
  
- **`/laporan/export/mutasi`** - Export Laporan Mutasi (Excel/PDF)

#### 17.4 Laporan Kegiatan
- **`/laporan/kegiatan`** - Laporan Kegiatan
  - Data kegiatan per periode
  - Statistik partisipan
  
- **`/laporan/export/kegiatan`** - Export Laporan Kegiatan (Excel/PDF)

#### 17.5 Laporan Kehadiran
- **`/laporan/kehadiran`** - Laporan Kehadiran
  - Rekap kehadiran per anggota
  - Tingkat kehadiran per kegiatan

#### 17.6 Laporan Takwim
- **`/laporan/takwim`** - Laporan Takwim
  - Progress program kaderisasi
  - Penilaian peserta

---

### 18. 🎯 MASTER DATA

#### 18.1 DPC (Dewan Pimpinan Cabang)
- **`/dpc`** - List DPC (lihat detail di section 6)
- **`/dpc/create`** - Tambah DPC Baru
- **`/dpc/{dpc}`** - Detail DPC
- **`/dpc/{dpc}/edit`** - Edit DPC

#### 18.2 Jenis Kegiatan
- **`/jenis-kegiatan`** - List Jenis Kegiatan
- **`/jenis-kegiatan/create`** - Tambah Jenis Kegiatan Baru
- **`/jenis-kegiatan/{jenisKegiatan}`** - Detail Jenis Kegiatan
- **`/jenis-kegiatan/{jenisKegiatan}/edit`** - Edit Jenis Kegiatan

#### 18.3 Keahlian
- **`/keahlian`** - List Keahlian
- **`/keahlian/create`** - Tambah Keahlian Baru
- **`/keahlian/{keahlian}`** - Detail Keahlian
- **`/keahlian/{keahlian}/edit`** - Edit Keahlian

#### 18.4 Indikator Takwim
- **`/indikator-takwim`** - List Indikator Takwim
- **`/indikator-takwim/create`** - Tambah Indikator Baru
- **`/indikator-takwim/{indikatorTakwim}`** - Detail Indikator
- **`/indikator-takwim/{indikatorTakwim}/edit`** - Edit Indikator

#### 18.5 Aktivitas Luar
- **`/aktivitas-luar`** - List Aktivitas Luar
- **`/aktivitas-luar/create`** - Tambah Aktivitas Luar Baru
- **`/aktivitas-luar/{aktivitasLuar}`** - Detail Aktivitas Luar
- **`/aktivitas-luar/{aktivitasLuar}/edit`** - Edit Aktivitas Luar

---

### 19. 👤 USER MANAGEMENT (Superadmin & Admin Only)

- **`/user-management`** - List Users
  - Tabel data user
  - Filter berdasarkan role

- **`/user-management/create`** - Tambah User Baru
  - Form create user
  - Assign role
  - Set permissions

- **`/user-management/{user_management}`** - Detail User
  - Informasi user
  - Role & permissions
  - Activity log

- **`/user-management/{user_management}/edit`** - Edit User
  - Update data user
  - Change role
  - Update permissions

- **`POST /user-management/{user_management}/toggle-status`** - Aktifkan/Nonaktifkan User

---

### 20. 👤 USER PROFILE & SETTINGS

- **`POST /change-password`** - Ganti Password
  - Form change password
  - Validasi password lama
  - Konfirmasi password baru

- **`POST /logout`** - Logout
  - Clear session
  - Redirect ke login

---

## 📱 MOBILE INTERFACE

### Mobile Dashboard & Features
- **`/mobile`** - Mobile Dashboard
  - Dashboard khusus mobile
  - Touch-friendly interface

- **`POST /mobile/select-anggota`** - Pilih Anggota (Mobile)

### Mobile Attendance
- **`/mobile/attendance`** - List Kegiatan (Mobile)
- **`/mobile/attendance/{kegiatan}`** - Detail Kegiatan & Absensi
- **`POST /mobile/attendance/checkin`** - Check-in Mobile
- **`POST /mobile/attendance/checkout`** - Check-out Mobile

### Mobile Mutasi
- **`/mobile/mutasi`** - List Mutasi (Mobile)
- **`/mobile/mutasi/create`** - Pengajuan Mutasi (Mobile)
- **`POST /mobile/mutasi/submit`** - Submit Mutasi Mobile
- **`/mobile/mutasi/{mutasi}`** - Detail Mutasi (Mobile)

### Mobile Profile
- **`/mobile/profile`** - Profil Anggota (Mobile)
- **`POST /mobile/profile/update`** - Update Profil Mobile

---

## 🔌 API ENDPOINTS (JSON)

### Alamat Cascading Dropdown
- **`/api/provinsi`** - Get List Provinsi (JSON)
- **`/api/kota?provinsi_id={id}`** - Get List Kota by Provinsi (JSON)
- **`/api/kecamatan?kota_id={id}`** - Get List Kecamatan by Kota (JSON)
- **`/api/kelurahan?kecamatan_id={id}`** - Get List Kelurahan by Kecamatan (JSON)

### Struktur Organisasi
- **`/api/dpc-by-dpd/{dpdId}`** - Get DPC by DPD (JSON)
- **`/api/upa-by-dpc/{dpcIds}`** - Get UPA by DPC (JSON)

### Anggota API
- **`/api/anggota/search?q={keyword}`** - Search Anggota (JSON)
- **`/api/anggota-paginated`** - Get Anggota Paginated (JSON)
- **`/api/struktur-organisasi`** - Get Struktur Organisasi (JSON)

### UPA API
- **`/api/anggota-upa?kode_upa={kode}`** - Get Anggota by UPA (JSON)
- **`/api/pembimbing-upa?kode_upa={kode}`** - Get Pembimbing by UPA (JSON)
- **`/anggota/api/upa-options?dpc_id={id}`** - Get UPA Options by DPC (JSON)

### Mutasi API
- **`/mutasi/get-dpc-by-dpd?dpd_id={id}`** - Get DPC by DPD untuk Mutasi (JSON)
- **`/mutasi/get-anggota-details?anggota_id={id}`** - Get Detail Anggota untuk Mutasi (JSON)

### Rekomposisi UPA API
- **`/rekomposisi-upa/anggota-by-dpc?dpc_id={id}`** - Get Anggota by DPC (JSON)
- **`/rekomposisi-upa/pembimbing-by-dpc?dpc_id={id}`** - Get Pembimbing by DPC (JSON)

### Surat Penempatan API
- **`/surat-penempatan/anggota-by-dpc?dpc_id={id}`** - Get Anggota by DPC (JSON)
- **`/surat-penempatan/upa-by-dpc?dpc_id={id}`** - Get UPA by DPC (JSON)
- **`/surat-penempatan/pembimbing-by-upa?upa_id={id}`** - Get Pembimbing by UPA (JSON)

### Yaumiyah API (untuk member portal)
- **`/api/yaumiyah/activities`** - Get List Activities (JSON)
- **`/api/yaumiyah/records?anggota_id={id}`** - Get Records by Anggota (JSON)
- **`POST /api/yaumiyah/records`** - Submit Yaumiyah Records (JSON)

---

## 🧪 TEST/DEBUG ROUTES (Development Only)

### Debug Routes
- **`/anggota/{anggota}/debug`** - Debug Data Anggota
- **`/anggota/{anggota}/simple`** - Simple View Anggota
- **`/test-upa-data`** - Test UPA Data (JSON)
- **`/test-anggota-upa?kode_upa={kode}`** - Test Anggota UPA (JSON)
- **`/test-api-debug`** - Test API Debug (JSON)

### Surat Testing
- **`/test-surat-mutasi`** - Test Surat Mutasi (Browser)
- **`/test-surat-mutasi-simple`** - Test Surat Mutasi Simple
- **`/test-pdf-simple`** - Test PDF Generation Simple
- **`/test-pdf-base64`** - Test PDF with Base64 Images
- **`/test-surat-penempatan`** - Test Surat Penempatan

---

## 🎯 FITUR KHUSUS

### 🔒 Middleware & Security
- **Authentication**: Semua route authenticated menggunakan `auth` middleware
- **Session Security**: `session.security` middleware untuk keamanan session
- **Role-Based Access**: Route tertentu dibatasi untuk `superadmin` dan `admin` only

### 📄 PDF Generation
- Surat Mutasi
- Surat Penempatan
- Kartu Anggota
- SK Rekomposisi UPA
- Laporan (Anggota, Mutasi, Kegiatan)

### 📊 Export Features
- Export Excel (Anggota, Mutasi, Kegiatan, Laporan)
- Export PDF (Laporan, Surat-surat)
- Template Import Excel

### 📸 QR Code
- QR Code untuk Check-in kegiatan
- QR Code scanner (mobile-friendly)
- Real-time attendance tracking

### 🔔 Real-time Features
- Live attendance updates
- Real-time search
- Auto-populate forms
- Cascading dropdowns

---

## 📊 STRUKTUR NAVIGASI SIDEBAR

```
📊 Dashboard

👥 KEANGGOTAAN
├── 👤 Data Anggota
├── 📥 Import Anggota
├── 📊 Statistik Anggota
└── 📄 Laporan Anggota

🔄 MUTASI & PERPINDAHAN
├── 🔄 Mutasi Anggota
├── 🔀 Perpindahan Anggota (Legacy)
├── 🔀 Perpindahan Anggota (Unified System)
└── 📄 Laporan Mutasi

🏢 MANAJEMEN UPA
├── 🏢 Data UPA
├── 📋 Kegiatan Kelompok UPA
├── 📝 Agenda Master UPA
├── 🔄 Rekomposisi UPA
└── 📄 Surat Penempatan UPA

📅 KEGIATAN & PROGRAM
├── 📅 Data Kegiatan
├── ✅ Absensi & Check-in
├── 📚 Takwim (Kaderisasi)
├── 🎯 Penilaian Peserta (Admin)
└── 📄 Laporan Kegiatan

📝 YAUMIYAH
├── 📊 Dashboard Yaumiyah
├── ✍️ Pencatatan Aktivitas
├── 📋 Master Aktivitas
├── 📜 Riwayat Pencatatan
└── 📊 Laporan Yaumiyah

📊 MASTER DATA
├── 🏢 Data DPC
├── 🎯 Jenis Kegiatan
├── 💼 Keahlian
├── 📊 Indikator Takwim
└── 🌐 Aktivitas Luar

📈 STATISTIK & LAPORAN
├── 📊 Statistik Anggota
├── 📊 Statistik Kegiatan
├── 📊 Statistik Mutasi
├── 📊 Statistik Takwim
└── 📄 Semua Laporan

👤 USER MANAGEMENT (Admin Only)
├── 👥 Kelola User
├── 🔑 Role & Permission
└── 🔒 User Status

⚙️ PENGATURAN
├── 👤 Profil Saya
├── 🔒 Ganti Password
└── 🚪 Logout
```

---

## 🎨 USER ROLES & AKSES

### 🔴 Superadmin
- **Full Access** ke semua fitur
- Manajemen user
- Approval mutasi & perpindahan
- Penilaian peserta takwim
- Export semua data
- Akses semua laporan

### 🟡 Admin
- Manajemen anggota
- Manajemen kegiatan
- Manajemen UPA
- Approval mutasi & perpindahan
- Penilaian peserta takwim
- Export data
- Akses laporan

### 🟢 User
- View data anggota (read-only)
- View kegiatan
- Check-in kegiatan
- Submit mutasi (untuk diri sendiri)
- Pencatatan yaumiyah
- View laporan terbatas

---

## 📱 RESPONSIVE BREAKPOINTS

### Desktop (≥1024px)
- Full sidebar navigation
- Tabel lengkap dengan semua kolom
- Dashboard dengan multiple widgets

### Tablet (768px - 1023px)
- Collapsible sidebar
- Tabel responsive dengan scroll horizontal
- Dashboard dengan 2 kolom

### Mobile (≤767px)
- Bottom navigation atau hamburger menu
- Card-based layout untuk data
- Single column dashboard
- Touch-friendly buttons & forms

---

## 🔗 EXTERNAL INTEGRATIONS

### APIs yang Tersedia
- RESTful API untuk mobile app
- JSON endpoints untuk AJAX calls
- Webhooks (future feature)

### Export Formats
- PDF (DomPDF)
- Excel (Maatwebsite Excel)
- CSV

### Import Formats
- Excel (.xlsx, .xls)
- CSV (dengan validasi)

---

## 📝 CATATAN PENTING

### Default Credentials
```
Superadmin:
- Email: superadmin@bkd.com
- Password: password123

Admin:
- Email: admin@bkd.com
- Password: password123

User:
- Email: user@bkd.com
- Password: password123
```

### Environment
- **Development**: http://localhost:8000
- **Production**: Sesuaikan dengan domain production

### Database
- **Development**: SQLite (database/database.sqlite)
- **Production**: MySQL 8.0+

---

## 🚀 QUICK LINKS UNTUK PROJECT OWNER

### Dokumentasi Lengkap
- 📋 [README.md](README.md) - Overview project
- 🚀 [FEATURES.md](FEATURES.md) - Fitur lengkap
- 🗄️ [DATABASE_SCHEMA.md](DATABASE_SCHEMA.md) - Struktur database
- 🔌 [API_DOCUMENTATION.md](API_DOCUMENTATION.md) - API reference
- 🚀 [DEPLOYMENT.md](DEPLOYMENT.md) - Deployment guide
- 📚 [DOCUMENTATION_INDEX.md](DOCUMENTATION_INDEX.md) - Index semua dokumentasi

### Testing URLs
1. Login ke sistem: http://localhost:8000/login
2. Dashboard: http://localhost:8000/dashboard
3. Data Anggota: http://localhost:8000/anggota
4. Mutasi: http://localhost:8000/mutasi
5. Kegiatan: http://localhost:8000/kegiatan
6. UPA: http://localhost:8000/upa
7. Laporan: http://localhost:8000/laporan

---

## 📞 SUPPORT

Untuk pertanyaan atau bantuan terkait navigasi sistem:
- Lihat dokumentasi lengkap di folder root project
- Gunakan fitur search di dalam aplikasi
- Hubungi tim development

---

**Dibuat dengan ❤️ untuk Partai Keadilan Sejahtera**
**© 2025 BKD PD - Sistem Informasi Anggota PKS**

