# Setup SSH untuk GitHub (Alternatif Token)

## 🔐 Keuntungan SSH
- Tidak perlu token
- Lebih aman
- No password needed setelah setup
- Recommended untuk development jangka panjang

## 📝 Setup SSH Key

### Step 1: Generate SSH Key

```bash
# Open PowerShell atau Git Bash
ssh-keygen -t ed25519 -C "mahrizalit@gmail.com"

# Press Enter untuk default location: C:\Users\YourName\.ssh\id_ed25519
# Enter passphrase (optional, boleh kosong)
# Press Enter lagi
```

### Step 2: Copy Public Key

```bash
# Windows PowerShell
type $env:USERPROFILE\.ssh\id_ed25519.pub

# Atau Git Bash
cat ~/.ssh/id_ed25519.pub

# COPY semua output (mulai dari ssh-ed25519 ... sampai email)
```

### Step 3: Add SSH Key ke GitHub

1. Buka: https://github.com/settings/keys
2. Klik **"New SSH key"**
3. Title: `BKDPD Development PC`
4. Key type: `Authentication Key`
5. Key: **PASTE** public key yang sudah di-copy
6. Klik **"Add SSH key"**

### Step 4: Test SSH Connection

```bash
ssh -T git@github.com

# Output kalau berhasil:
# Hi mahrizalit! You've successfully authenticated...
```

### Step 5: Change Remote URL ke SSH

```bash
git remote set-url origin git@github.com:mahrizalit/bkdpd.git
```

### Step 6: Push (Tanpa Token!)

```bash
git push -u origin feature/unified-transfer-system

# Kalau diminta passphrase, masukkan passphrase SSH key
# (kalau tadi bikin tanpa passphrase, langsung push)
```

## ✅ Selesai!

Setelah setup, next time cukup:
```bash
git push
```

Tanpa token, tanpa password! 🎉

## 🆚 Token vs SSH

| Feature | Personal Access Token | SSH Key |
|---------|----------------------|---------|
| Setup | Mudah (2 menit) | Agak ribet (5 menit) |
| Security | Aman | Lebih aman |
| Expiration | Bisa expire | Tidak expire |
| Usage | Input sekali | Tidak perlu input |
| Best for | Quick setup | Long-term development |

## 💡 Rekomendasi

- **Token:** Kalau mau cepat, pakai token (recommended untuk sekarang)
- **SSH:** Kalau mau setup permanent, pakai SSH (recommended untuk production)

Kedua-duanya **support private repository** dengan sempurna!



