@echo off
echo ========================================
echo  Setup Git Authentication
echo ========================================
echo.
echo Ikuti langkah berikut:
echo.
echo 1. Buat Personal Access Token:
echo    https://github.com/settings/tokens/new
echo.
echo    Settings:
echo    - Note: BKDPD Development
echo    - Expiration: 90 days atau No expiration
echo    - Scope: Centang "repo" (full control)
echo    - Generate token
echo    - COPY TOKEN (format: ghp_xxxxx...)
echo.
echo 2. Setelah punya token, paste di bawah
echo.
pause

echo.
set /p TOKEN="Paste Personal Access Token: "

echo.
echo Configuring Git credential...
git config --global credential.helper store

echo.
echo Setting remote URL with authentication...
git remote set-url origin https://%TOKEN%@github.com/mahrizalit/bkdpd.git

echo.
echo Testing push...
git push -u origin feature/unified-transfer-system

echo.
if %ERRORLEVEL% EQU 0 (
    echo ========================================
    echo SUCCESS! Push berhasil!
    echo ========================================
    echo.
    echo Credential sudah tersimpan.
    echo Next time cukup: git push
    echo.
    echo Cek hasil:
    echo https://github.com/mahrizalit/bkdpd
    echo.
    echo GitHub Actions:
    echo https://github.com/mahrizalit/bkdpd/actions
    echo.
) else (
    echo ========================================
    echo FAILED! Push gagal
    echo ========================================
    echo.
    echo Pastikan:
    echo 1. Token sudah benar
    echo 2. Scope "repo" sudah dicentang
    echo 3. Repository accessible
    echo.
)

pause



