# 🏛️ Sistem Manajemen Anggota PKS (BKD PD)

## 📋 Overview

**Sistem Manajemen Anggota PKS** adalah aplikasi web yang dikembangkan untuk mengelola data anggota Partai Keadilan Sejahtera (PKS) di tingkat DPD (Dewan Pimpinan Daerah). Aplikasi ini menyediakan fitur lengkap untuk manajemen anggota, mutasi, kegiatan, takwim, dan laporan.

### 🎯 Tujuan
- Mengelola data anggota PKS secara terpusat dan terstruktur
- Memudahkan proses mutasi anggota antar DPC/DPD
- Mengelola kegiatan dan takwim organisasi
- Menyediakan laporan dan statistik yang komprehensif
- Memastikan keamanan data dengan enkripsi

## 🚀 Fitur Utama

### 👥 Manajemen Anggota
- **CRUD Anggota**: Tambah, lihat, edit, hapus data anggota
- **Import/Export**: Import data dari Excel dan export ke berbagai format
- **Pencarian**: Pencarian anggota dengan filter canggih
- **Foto Profil**: Upload dan kelola foto anggota
- **Enkripsi Data**: Data sensitif dienkripsi untuk keamanan

### 🔄 Sistem Mutasi
- **Pengajuan Mutasi**: Anggota dapat mengajukan mutasi
- **Approval System**: Sistem persetujuan mutasi
- **Surat Mutasi**: Generate surat mutasi otomatis
- **Tracking**: Melacak status mutasi

### 📅 Manajemen Kegiatan
- **CRUD Kegiatan**: Kelola kegiatan organisasi
- **Absensi**: Sistem absensi dengan QR code
- **Partisipan**: Kelola peserta kegiatan
- **Laporan Kehadiran**: Generate laporan kehadiran

### 📊 Takwim & Penilaian
- **Takwim**: Jadwal kegiatan dan program
- **Penilaian Peserta**: Sistem penilaian peserta takwim
- **Indikator**: Kelola indikator penilaian

### 📈 Laporan & Statistik
- **Dashboard**: Overview data dan statistik
- **Laporan Anggota**: Laporan data anggota
- **Laporan Mutasi**: Laporan perpindahan anggota
- **Laporan Kegiatan**: Laporan kegiatan dan kehadiran

### 🔐 Sistem Keamanan
- **Authentication**: Login/logout dengan role-based access
- **Role Management**: Superadmin, Admin, User
- **Data Encryption**: Enkripsi data sensitif
- **Session Security**: Keamanan session

## 🛠️ Teknologi yang Digunakan

### Backend
- **Laravel 12** - PHP Framework
- **PHP 8.2+** - Bahasa pemrograman
- **MySQL** - Database
- **SQLite** - Database development

### Frontend
- **Blade Templates** - Template engine
- **Bootstrap 5** - CSS Framework
- **Tailwind CSS 4** - Utility-first CSS
- **JavaScript** - Interaktivitas
- **Vite** - Build tool

### Libraries & Packages
- **Laravel DomPDF** - Generate PDF
- **Maatwebsite Excel** - Import/Export Excel
- **Laravel Tinker** - Command line interface

## 📁 Struktur Project

```
bkdpd/
├── app/                    # Aplikasi Laravel
│   ├── Http/Controllers/   # Controller
│   ├── Models/            # Model Eloquent
│   ├── Middleware/        # Middleware
│   └── Helpers/           # Helper functions
├── database/              # Database
│   ├── migrations/        # Database migrations
│   └── seeders/          # Database seeders
├── resources/             # Resources
│   ├── views/            # Blade templates
│   ├── css/              # Stylesheets
│   └── js/               # JavaScript
├── routes/               # Route definitions
├── public/               # Public assets
├── storage/              # File storage
└── vendor/               # Composer dependencies
```

## 🚀 Quick Start

### Prerequisites
- PHP 8.2 atau lebih tinggi
- Composer
- MySQL/SQLite
- Node.js & NPM

### Installation

1. **Clone Repository**
```bash
git clone <repository-url>
cd bkdpd
```

2. **Install Dependencies**
```bash
composer install
npm install
```

3. **Environment Setup**
```bash
cp .env.example .env
php artisan key:generate
```

4. **Database Setup**
```bash
php artisan migrate
php artisan db:seed
```

5. **Build Assets**
```bash
npm run build
```

6. **Run Application**
```bash
php artisan serve
```

Aplikasi akan berjalan di `http://localhost:8000`

## 👤 Default Users

### Superadmin
- **Email**: superadmin@bkd.com
- **Password**: password123

### Admin
- **Email**: admin@bkd.com
- **Password**: password123

### User
- **Email**: user@bkd.com
- **Password**: password123

## 📖 Dokumentasi Lengkap

### 🎯 Quick Start (Untuk Project Owner)
- [📋 Quick Reference](QUICK_REFERENCE.md) - **MULAI DI SINI: Panduan cepat testing & pengecekan**

### 🗺️ Navigasi & Struktur
- [🗺️ Sitemap Aplikasi](SITEMAP.md) - Navigasi lengkap semua fitur aplikasi
- [🎨 Visual Sitemap](SITEMAP_VISUAL.md) - Diagram dan workflow aplikasi

### 📚 Dokumentasi Teknis
- [📋 Panduan Instalasi](INSTALLATION.md)
- [⚡ Fitur-Fitur Aplikasi](FEATURES.md)
- [🗄️ Struktur Database](DATABASE_SCHEMA.md)
- [🔌 API Documentation](API_DOCUMENTATION.md)
- [🚀 Panduan Deployment](DEPLOYMENT.md)
- [🔄 CI/CD Setup](CI_CD_SETUP.md) - **GitHub Actions untuk automated testing & deployment**
- [👥 Manajemen User](USER_MANAGEMENT.md)
- [🔐 Sistem Authentication](AUTHENTICATION.md)
- [🎨 Panduan Tema](THEME_GUIDE.md)
- [📱 Mobile Responsive](MOBILE_RESPONSIVE_GUIDE.md)
- [⚡ Optimasi Performa](PERFORMANCE_OPTIMIZATION.md)
- [🔒 Panduan Enkripsi](ENCRYPTION_GUIDE.md)
- [📚 Index Dokumentasi](DOCUMENTATION_INDEX.md) - Index lengkap semua dokumentasi

## 🎯 Fitur Unggulan

### 🔐 Keamanan Data
- Enkripsi data sensitif (NIK, alamat, telepon, email)
- Role-based access control
- Session security
- CSRF protection

### 📱 Mobile Responsive
- Design responsive untuk semua device
- Touch-friendly interface
- Mobile-optimized forms

### ⚡ Performa Tinggi
- Database indexing
- Query optimization
- Caching system
- Lazy loading

### 📊 Laporan Komprehensif
- Export ke PDF dan Excel
- Dashboard statistik real-time
- Filter dan pencarian canggih

## 🔄 CI/CD Pipeline

Aplikasi ini dilengkapi dengan **GitHub Actions** untuk automated testing dan deployment:

### ✅ Continuous Integration (CI)
- Otomatis run tests saat push/pull request
- Code quality check dengan Laravel Pint
- Security vulnerability scan
- Build assets verification

### 🚀 Continuous Deployment (CD)
- Otomatis deploy ke production saat push ke `main`
- Support deployment via SSH, FTP, atau cPanel
- Post-deployment health checks
- Cache optimization otomatis

**Setup Guide:** Lihat [CI_CD_SETUP.md](CI_CD_SETUP.md) untuk panduan lengkap.

## 🤝 Kontribusi

1. Fork repository
2. Buat feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit changes (`git commit -m 'Add some AmazingFeature'`)
4. Push ke branch (`git push origin feature/AmazingFeature`)
5. Buat Pull Request (CI akan otomatis run tests)

## 📄 Lisensi

Project ini menggunakan lisensi MIT. Lihat file [LICENSE](LICENSE) untuk detail.

## 📞 Support

Untuk pertanyaan atau bantuan, silakan hubungi:
- **Email**: support@bkd.com
- **Documentation**: [Link ke dokumentasi lengkap]

---

**Dibuat dengan ❤️ untuk Partai Keadilan Sejahtera**