# 📋 QUICK REFERENCE - Sistem Informasi Anggota PKS

> Panduan cepat untuk Project Owner dalam melakukan pengecekan aplikasi

---

## 🔑 LOGIN CREDENTIALS

```
SUPERADMIN
Email:    superadmin@bkd.com
Password: password123

ADMIN
Email:    admin@bkd.com
Password: password123

USER
Email:    user@bkd.com
Password: password123
```

---

## 🌐 URL TESTING (Development)

### Main URLs
```
Base URL:      http://localhost:8000
Login:         http://localhost:8000/login
Dashboard:     http://localhost:8000/dashboard
```

### Quick Access URLs
```
📊 ANGGOTA
   List:       http://localhost:8000/anggota
   Create:     http://localhost:8000/anggota/create
   Import:     http://localhost:8000/anggota/import
   Statistik:  http://localhost:8000/anggota/statistik

🔄 MUTASI
   List:       http://localhost:8000/mutasi
   Create:     http://localhost:8000/mutasi/create

🔀 PERPINDAHAN (Legacy)
   List:       http://localhost:8000/perpindahan
   Create:     http://localhost:8000/perpindahan/create

🔀 PERPINDAHAN ANGGOTA (Unified System)
   List:       http://localhost:8000/perpindahan-anggota
   Create:     http://localhost:8000/perpindahan-anggota/create

🏢 DPC (Dewan Pimpinan Cabang)
   List:       http://localhost:8000/dpc
   Create:     http://localhost:8000/dpc/create

📅 KEGIATAN
   List:       http://localhost:8000/kegiatan
   Create:     http://localhost:8000/kegiatan/create

🏢 UPA
   List:       http://localhost:8000/upa
   Create:     http://localhost:8000/upa/create

📋 UPA GROUP ACTIVITY
   List:       http://localhost:8000/upa-group-activity
   Create:     http://localhost:8000/upa-group-activity/create

📝 UPA AGENDA MASTER
   List:       http://localhost:8000/upa-agenda-master
   Create:     http://localhost:8000/upa-agenda-master/create

🔄 REKOMPOSISI UPA
   List:       http://localhost:8000/rekomposisi-upa
   Create:     http://localhost:8000/rekomposisi-upa/create

📄 SURAT PENEMPATAN
   Create:     http://localhost:8000/surat-penempatan/create

📚 TAKWIM
   List:       http://localhost:8000/takwim
   Create:     http://localhost:8000/takwim/create

🎯 PENILAIAN PESERTA (Admin Only)
   List:       http://localhost:8000/penilaian-peserta
   Create:     http://localhost:8000/penilaian-peserta/create

📝 YAUMIYAH
   Dashboard:  http://localhost:8000/yaumiyah
   Activities: http://localhost:8000/yaumiyah/activities
   Records:    http://localhost:8000/yaumiyah/records

📊 MASTER DATA
   DPC:               http://localhost:8000/dpc
   Jenis Kegiatan:    http://localhost:8000/jenis-kegiatan
   Keahlian:          http://localhost:8000/keahlian
   Indikator Takwim:  http://localhost:8000/indikator-takwim
   Aktivitas Luar:    http://localhost:8000/aktivitas-luar

📈 STATISTIK
   Dashboard:  http://localhost:8000/statistik
   Anggota:    http://localhost:8000/statistik/anggota
   Kegiatan:   http://localhost:8000/statistik/kegiatan
   Mutasi:     http://localhost:8000/statistik/mutasi
   Takwim:     http://localhost:8000/statistik/takwim

📄 LAPORAN
   Dashboard:  http://localhost:8000/laporan
   Anggota:    http://localhost:8000/laporan/anggota
   Mutasi:     http://localhost:8000/laporan/mutasi
   Kegiatan:   http://localhost:8000/laporan/kegiatan
   Kehadiran:  http://localhost:8000/laporan/kehadiran
   Takwim:     http://localhost:8000/laporan/takwim

👤 USER MANAGEMENT (Admin Only)
   List:       http://localhost:8000/user-management
   Create:     http://localhost:8000/user-management/create

📱 MOBILE INTERFACE
   Dashboard:  http://localhost:8000/mobile
   Attendance: http://localhost:8000/mobile/attendance
   Mutasi:     http://localhost:8000/mobile/mutasi
   Profile:    http://localhost:8000/mobile/profile
```

---

## ✅ TESTING CHECKLIST

### 1. Authentication & Authorization ✓
- [ ] Login dengan superadmin
- [ ] Login dengan admin
- [ ] Login dengan user
- [ ] Test logout
- [ ] Test change password
- [ ] Verify role-based access (admin pages tidak bisa diakses user biasa)

### 2. Manajemen Anggota ✓
- [ ] View list anggota
- [ ] Tambah anggota baru
- [ ] Edit data anggota
- [ ] View detail anggota
- [ ] Upload foto profil
- [ ] Import anggota dari Excel
- [ ] Export anggota ke Excel
- [ ] Print kartu anggota (PDF)
- [ ] Search & filter anggota
- [ ] View statistik anggota

### 3. Keanggotaan Anggota ✓
- [ ] View keanggotaan anggota
- [ ] Edit keanggotaan (jenjang, UPA, DPC)
- [ ] View history keanggotaan
- [ ] Export history ke Excel

### 4. Mutasi & Perpindahan ✓
- [ ] Submit mutasi baru
- [ ] Approve mutasi (admin)
- [ ] Reject mutasi (admin)
- [ ] Print surat mutasi
- [ ] View history mutasi
- [ ] Export data mutasi
- [ ] Submit perpindahan (legacy)
- [ ] Approve/reject perpindahan (legacy)
- [ ] Print surat perpindahan (legacy)
- [ ] Submit perpindahan anggota (unified system)
- [ ] Download surat perpindahan (unified system)
- [ ] Test cascading dropdown (DPC > UPA > Anggota > Pembimbing)

### 5. Manajemen DPC ✓
- [ ] View list DPC
- [ ] Create DPC baru
- [ ] Edit DPC
- [ ] View detail DPC
- [ ] Toggle status DPC (aktif/nonaktif)
- [ ] View UPA per DPC
- [ ] View anggota per DPC
- [ ] View statistik DPC

### 6. Manajemen UPA ✓
- [ ] Create UPA baru
- [ ] View detail UPA
- [ ] Edit UPA
- [ ] View anggota per UPA
- [ ] Create kegiatan kelompok UPA
- [ ] View agenda master UPA
- [ ] Create agenda master baru
- [ ] Toggle status agenda
- [ ] Submit rekomposisi UPA
- [ ] Approve rekomposisi
- [ ] Print SK rekomposisi
- [ ] Generate surat penempatan

### 7. Kegiatan & Absensi ✓
- [ ] Create kegiatan baru
- [ ] View detail kegiatan
- [ ] Edit kegiatan
- [ ] Add partisipan
- [ ] Generate QR code untuk check-in
- [ ] Test QR code scanner (mobile)
- [ ] Manual check-in
- [ ] View real-time statistics
- [ ] Export laporan kehadiran

### 8. Takwim & Penilaian ✓
- [ ] Create takwim baru
- [ ] View detail takwim
- [ ] Add peserta takwim
- [ ] Remove peserta
- [ ] Input penilaian peserta (admin)
- [ ] View laporan penilaian
- [ ] Export hasil penilaian

### 9. Yaumiyah ✓
- [ ] View dashboard yaumiyah
- [ ] Create master activity
- [ ] Edit master activity
- [ ] Record aktivitas harian
- [ ] View riwayat pencatatan
- [ ] View laporan yaumiyah
- [ ] Test API yaumiyah

### 10. Master Data ✓
- [ ] CRUD DPC
- [ ] CRUD Jenis Kegiatan
- [ ] CRUD Keahlian
- [ ] CRUD Indikator Takwim
- [ ] CRUD Aktivitas Luar

### 11. Statistik & Laporan ✓
- [ ] View dashboard statistik
- [ ] View statistik per modul (anggota, kegiatan, mutasi, takwim)
- [ ] Generate laporan anggota
- [ ] Generate laporan mutasi
- [ ] Generate laporan kegiatan
- [ ] Generate laporan kehadiran
- [ ] Export laporan ke Excel
- [ ] Export laporan ke PDF

### 12. User Management (Admin) ✓
- [ ] Create user baru
- [ ] Edit user
- [ ] Assign role ke user
- [ ] Toggle user status (aktif/nonaktif)
- [ ] View user detail

### 13. Mobile Interface ✓
- [ ] Access mobile dashboard
- [ ] Mobile attendance check-in
- [ ] Mobile mutasi submission
- [ ] Mobile profile view
- [ ] Test responsive design (resize browser)

### 14. API Testing ✓
- [ ] Test alamat API (provinsi, kota, kecamatan, kelurahan)
- [ ] Test anggota search API
- [ ] Test UPA API
- [ ] Test yaumiyah API

### 15. PDF Generation ✓
- [ ] Kartu anggota
- [ ] Surat mutasi
- [ ] Surat perpindahan
- [ ] Surat penempatan UPA
- [ ] SK rekomposisi UPA
- [ ] Laporan-laporan

### 16. Data Import/Export ✓
- [ ] Import anggota dari Excel
- [ ] Export anggota ke Excel
- [ ] Export mutasi ke Excel
- [ ] Export kegiatan ke Excel
- [ ] Download template import

---

## 🎯 FITUR UTAMA YANG HARUS DICEK

### Priority 1 (MUST WORK) ⭐⭐⭐
1. **Login & Authentication** - Login dengan 3 role berbeda
2. **Dashboard** - Statistik dan overview
3. **CRUD Anggota** - Create, Read, Update, Delete anggota
4. **Mutasi Anggota** - Submit dan approval mutasi
5. **Kegiatan & Absensi** - Create kegiatan dan check-in
6. **UPA Management** - Kelola UPA dan anggotanya
7. **Laporan** - Generate dan export laporan

### Priority 2 (IMPORTANT) ⭐⭐
1. **Import/Export Anggota** - Excel import/export
2. **Keanggotaan History** - Tracking perubahan keanggotaan
3. **Rekomposisi UPA** - Rekomposisi dan approval
4. **Takwim & Penilaian** - Program kaderisasi
5. **Yaumiyah** - Aktivitas harian
6. **User Management** - Kelola user sistem
7. **Mobile Interface** - Responsive design

### Priority 3 (NICE TO HAVE) ⭐
1. **Statistik Advanced** - Chart dan grafik
2. **QR Code Scanner** - Mobile check-in
3. **Master Data** - Jenis kegiatan, keahlian, dll
4. **API Integration** - API endpoints
5. **Surat-surat** - Generate PDF

---

## 🐛 COMMON ISSUES & SOLUTIONS

### Issue: Tidak bisa login
```
✓ Check: Database sudah di-seed? (php artisan db:seed)
✓ Check: Session driver configured? (php artisan config:cache)
✓ Check: Gunakan credentials yang benar
```

### Issue: Import Excel error
```
✓ Check: File format (.xlsx atau .xls)
✓ Check: Download template import dulu
✓ Check: Kolom sesuai dengan template
```

### Issue: PDF tidak generate
```
✓ Check: DomPDF installed? (composer install)
✓ Check: Storage folder writable?
✓ Check: Memory limit PHP cukup?
```

### Issue: QR Code tidak muncul
```
✓ Check: SimpleSoftwareIO/simple-qrcode installed?
✓ Check: GD extension enabled di PHP?
```

### Issue: Foto tidak upload
```
✓ Check: storage/app/public/photos folder exists?
✓ Check: php artisan storage:link sudah dijalankan?
✓ Check: File size < max upload (check php.ini)
```

### Issue: Dropdown DPC/UPA kosong
```
✓ Check: Database sudah di-seed dengan data referensi?
✓ Check: php artisan db:seed --class=StrukturOrganisasiSeeder
```

---

## 📞 SUPPORT & HELP

### Dokumentasi Lengkap
- 🗺️ [SITEMAP.md](SITEMAP.md) - Navigasi lengkap aplikasi
- 🎨 [SITEMAP_VISUAL.md](SITEMAP_VISUAL.md) - Diagram visual
- 📖 [README.md](README.md) - Project overview
- 🚀 [FEATURES.md](FEATURES.md) - Dokumentasi fitur
- 📚 [DOCUMENTATION_INDEX.md](DOCUMENTATION_INDEX.md) - Index semua dokumentasi

### Useful Commands
```bash
# Development server
php artisan serve

# Clear cache
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Database
php artisan migrate
php artisan db:seed

# Storage link
php artisan storage:link

# Assets
npm run dev          # Development
npm run build        # Production
```

### Database Connection
```
Development:  SQLite (database/database.sqlite)
Production:   MySQL 8.0+
```

---

## 🎨 BROWSER COMPATIBILITY

### Recommended Browsers
- ✅ Google Chrome (latest)
- ✅ Mozilla Firefox (latest)
- ✅ Microsoft Edge (latest)
- ✅ Safari (latest)

### Mobile Testing
- ✅ Android Chrome
- ✅ iOS Safari
- ✅ Mobile responsive (min width: 320px)

---

## 📊 PERFORMANCE NOTES

### Expected Load Times
- Dashboard: < 2 seconds
- List pages: < 3 seconds
- Detail pages: < 1 second
- PDF generation: 3-5 seconds
- Excel export: 2-4 seconds

### Database
- 30+ tables
- 16+ indexes untuk performa
- Data encryption untuk field sensitif

---

## ✨ KEY FEATURES TO HIGHLIGHT

1. **🔐 Security**: Data encryption + role-based access
2. **📱 Mobile**: Fully responsive design
3. **📊 Reports**: Export to Excel & PDF
4. **🔄 Workflow**: Approval system untuk mutasi & rekomposisi
5. **✅ Attendance**: QR code check-in system
6. **📈 Analytics**: Real-time statistics & charts
7. **📝 Yaumiyah**: Daily activity tracking
8. **🏢 DPC**: Complete DPC management system with status control
9. **🏢 UPA**: Complete UPA management system
10. **🔀 Perpindahan Anggota (Unified)**: Integrated member transfer system with cascading dropdowns
11. **📚 Takwim**: Training program with assessment
12. **🔄 Import/Export**: Bulk data operations

---

## 📅 VERSION INFO

```
Application:  Sistem Informasi Anggota PKS
Version:      1.0.0
Framework:    Laravel 12
PHP:          8.2+
Database:     MySQL 8.0+ / SQLite
Frontend:     Blade + Bootstrap 5 + Tailwind CSS 4
```

---

## 🚀 NEXT STEPS AFTER TESTING

1. ✅ Complete all testing checklist
2. 📝 Note any bugs or issues found
3. 🎨 Review UI/UX
4. 📊 Verify all reports are working
5. 🔒 Confirm security features
6. 📱 Test on different devices
7. 🚀 Ready for production deployment!

---

**© 2025 BKD PD - Sistem Informasi Anggota PKS**
**Dibuat dengan ❤️ untuk Partai Keadilan Sejahtera**

---

**CATATAN PENTING UNTUK PROJECT OWNER:**
- Gunakan file ini sebagai panduan cepat saat melakukan pengecekan
- Lihat [SITEMAP.md](SITEMAP.md) untuk detail lengkap semua fitur
- Lihat [SITEMAP_VISUAL.md](SITEMAP_VISUAL.md) untuk diagram visual
- Semua credentials adalah untuk development/testing only
- Untuk production, ganti semua default passwords!

