@echo off
echo ========================================
echo  Push to GitHub dengan Token
echo ========================================
echo.
echo Sudah punya token? 
echo Kalau belum, buat di: https://github.com/settings/tokens/new
echo.
echo Settings token:
echo - Note: BKDPD Development  
echo - Expiration: 90 days
echo - Scope: Centang "repo"
echo.
pause

echo.
set /p TOKEN="Paste Personal Access Token (ghp_xxxxx...): "

if "%TOKEN%"=="" (
    echo Error: Token tidak boleh kosong!
    pause
    exit /b 1
)

echo.
echo Configuring remote dengan token...
git remote set-url origin https://%TOKEN%@github.com/mahrizalit/bkdpd.git

echo.
echo Pushing to GitHub...
git push -u origin feature/unified-transfer-system

echo.
if %ERRORLEVEL% EQU 0 (
    echo ========================================
    echo  SUCCESS! Push Berhasil!
    echo ========================================
    echo.
    echo Token sudah tersimpan di Windows Credential Manager
    echo Next time cukup: git push
    echo.
    echo Cek hasil push:
    echo https://github.com/mahrizalit/bkdpd/tree/feature/unified-transfer-system
    echo.
    echo Cek GitHub Actions:
    echo https://github.com/mahrizalit/bkdpd/actions
    echo.
    echo CI/CD akan otomatis run tests!
    echo.
) else (
    echo ========================================
    echo  FAILED! Push Gagal
    echo ========================================
    echo.
    echo Kemungkinan penyebab:
    echo 1. Token salah atau expired
    echo 2. Scope "repo" belum dicentang
    echo 3. Repository tidak accessible
    echo.
    echo Coba buat token baru di:
    echo https://github.com/settings/tokens/new
    echo.
)

echo.
echo Mengembalikan remote URL...
git remote set-url origin https://github.com/mahrizalit/bkdpd.git

pause



