@echo off
echo ========================================
echo  Push CI/CD Files Only
echo ========================================
echo.
echo Ini akan push file CI/CD saja:
echo - .github/workflows/ci.yml
echo - .github/workflows/deploy.yml  
echo - CI_CD_SETUP.md
echo - GITHUB_SETUP.md
echo.
echo File lain akan di-push nanti.
echo.
pause

echo.
echo Creating new branch untuk CI/CD...
git checkout -b feature/add-cicd-pipeline

echo.
echo Adding CI/CD files only...
git add .github/
git add CI_CD_SETUP.md
git add GITHUB_SETUP.md
git add README.md
git add DOCUMENTATION_INDEX.md

echo.
echo Committing...
git commit -m "feat: Add CI/CD pipeline with GitHub Actions

- Add CI workflow for automated testing
- Add CD workflow for automated deployment  
- Support PHP 8.1 & 8.2 testing
- Support Node 18 & 20 builds
- Add comprehensive documentation
- Update README with CI/CD section"

echo.
echo Pushing to GitHub...
git push -u origin feature/add-cicd-pipeline

echo.
if %ERRORLEVEL% EQU 0 (
    echo ========================================
    echo SUCCESS! CI/CD files berhasil di-push!
    echo ========================================
    echo.
    echo Buat Pull Request:
    echo https://github.com/mahrizalit/bkdpd/compare/feature/add-cicd-pipeline
    echo.
    echo Setelah di-merge, GitHub Actions akan aktif!
    echo.
) else (
    echo ========================================  
    echo Push gagal. Gunakan GitHub Desktop atau
    echo coba PUSH_MANUAL.bat dengan token
    echo ========================================
)

pause



