# Mutasi Form Update - Visual Guide

## Perubahan Form Tambah Mutasi

### SEBELUM UPDATE ❌

```
┌─────────────────────────────────────────────────────────┐
│ Tambah Mutasi Keluar                                    │
├─────────────────────────────────────────────────────────┤
│                                                          │
│ [Anggota ▼]              [Tanggal Mutasi]               │
│                                                          │
│ [DPC Asal ▼]             [DPD Tujuan ▼] *               │
│                                                          │
│ [DPC Tujuan ▼] *         (kosong)                       │
│                                                          │
│ (User harus pilih manual semua field)                   │
└─────────────────────────────────────────────────────────┘
```

**Masalah:**
- User harus pilih DPC Asal secara manual
- Tidak ada field DPD Asal
- DPC Tujuan wajib diisi (padahal kadang tidak diperlukan)

---

### SESUDAH UPDATE ✅

```
┌─────────────────────────────────────────────────────────┐
│ Tambah Mutasi Keluar                                    │
├─────────────────────────────────────────────────────────┤
│                                                          │
│ [Anggota ▼]              [Tanggal Mutasi]               │
│                                                          │
│ ──────────── Data Asal ────────────                     │
│                                                          │
│ [DPD Asal (readonly)]    [DPC Asal (readonly)]          │
│ 🔒 Otomatis terisi       🔒 Otomatis terisi             │
│                                                          │
│ ──────────── Data Tujuan ──────────                     │
│                                                          │
│ [DPD Tujuan ▼] *         [DPC Tujuan ▼] (Opsional)     │
│                                                          │
└─────────────────────────────────────────────────────────┘
```

**Keuntungan:**
- DPC Asal dan DPD Asal otomatis terisi saat pilih anggota
- Form lebih terorganisir dengan section "Data Asal" dan "Data Tujuan"
- DPC Tujuan tidak wajib diisi (lebih fleksibel)

---

## Flow Kerja Baru

### 1️⃣ User Memilih Anggota
```
User: Pilih "Abdul Aziz (PKS004-20250014)"
       ⬇️
System: Fetch data anggota via AJAX
       ⬇️
System: DPD Asal = "Jakarta Selatan" (otomatis)
        DPC Asal = "DPC Jagakarsa" (otomatis)
```

### 2️⃣ User Pilih Tujuan
```
User: Pilih DPD Tujuan = "Jawa Barat"
       ⬇️
System: Load list DPC di Jawa Barat
       ⬇️
User: (Opsional) Pilih DPC Tujuan = "DPC Bandung"
```

### 3️⃣ Data Tersimpan
```sql
INSERT INTO tbl_mutasi (
    anggota_id,
    struktur_dari,  -- DPC Asal ID
    dpd_dari,       -- DPD Asal ID (BARU!)
    struktur_ke,    -- DPC Tujuan ID (atau NULL)
    dpd_ke,         -- DPD Tujuan ID (BARU!)
    ...
)
```

---

## Tampilan Detail Mutasi

### SEBELUM ❌
```
┌────────────────────────────────────┐
│ Detail Mutasi Keluar               │
├────────────────────────────────────┤
│ Nama: Abdul Aziz                   │
│ NIA: PKS004-20250014               │
│ Tanggal: 12/10/2025               │
│                                    │
│ DPD Tujuan: Jawa Barat            │
│ Alasan: Pindah Domisili           │
│                                    │
│ (Tidak ada info DPD/DPC Asal)     │
└────────────────────────────────────┘
```

### SESUDAH ✅
```
┌────────────────────────────────────────────────────────────┐
│ Detail Mutasi Keluar                                        │
├────────────────────────────────────────────────────────────┤
│ Nama: Abdul Aziz                                            │
│ NIA: PKS004-20250014                                        │
│ Tanggal: 12/10/2025                                        │
│                                                             │
│ ════════════ Data Perpindahan ════════════                 │
│                                                             │
│ ┌─────────────────────┐    ┌─────────────────────┐        │
│ │      ASAL 🔵       │    │     TUJUAN 🟢      │        │
│ ├─────────────────────┤    ├─────────────────────┤        │
│ │ DPD: Jakarta Selatan│    │ DPD: Jawa Barat     │        │
│ │ DPC: DPC Jagakarsa  │    │ DPC: DPC Bandung    │        │
│ └─────────────────────┘    └─────────────────────┘        │
│                                                             │
│ Alasan: Pindah Domisili                                    │
│ Alamat Tujuan: Jl. Sudirman No. 123, Bandung              │
└────────────────────────────────────────────────────────────┘
```

---

## Workflow Diagram

```
┌──────────────┐
│ User Login   │
└──────┬───────┘
       │
       ▼
┌──────────────────┐
│ Buka Form Mutasi │
└──────┬───────────┘
       │
       ▼
┌────────────────────────────┐
│ Pilih Anggota dari Dropdown│
└────────┬───────────────────┘
         │
         ▼
┌──────────────────────────────────────┐
│ AJAX Call ke:                        │
│ /mutasi/get-anggota-details          │
└────────┬─────────────────────────────┘
         │
         ▼
┌──────────────────────────────────────┐
│ Response JSON:                       │
│ {                                    │
│   "dpc_id": 123,                     │
│   "dpc_nama": "DPC Jagakarsa",       │
│   "dpd_id": 456,                     │
│   "dpd_nama": "Jakarta Selatan"      │
│ }                                    │
└────────┬─────────────────────────────┘
         │
         ▼
┌──────────────────────────────────────┐
│ Form Auto-Fill:                      │
│ • DPD Asal = "Jakarta Selatan"       │
│ • DPC Asal = "DPC Jagakarsa"         │
└────────┬─────────────────────────────┘
         │
         ▼
┌────────────────────────┐
│ User pilih DPD Tujuan  │
└────────┬───────────────┘
         │
         ▼
┌────────────────────────┐
│ (Opsional) Pilih DPC   │
│ Tujuan                 │
└────────┬───────────────┘
         │
         ▼
┌────────────────────────┐
│ Isi form lainnya       │
│ (Alasan, Alamat, dll)  │
└────────┬───────────────┘
         │
         ▼
┌────────────────────────┐
│ Submit Form            │
└────────┬───────────────┘
         │
         ▼
┌────────────────────────────────┐
│ Data Tersimpan ke Database:    │
│ • anggota_id                   │
│ • struktur_dari (DPC Asal)     │
│ • dpd_dari (DPD Asal) ✨ BARU │
│ • struktur_ke (DPC Tujuan)     │
│ • dpd_ke (DPD Tujuan) ✨ BARU │
│ • alamat_tujuan                │
│ • alasan_mutasi                │
└────────┬───────────────────────┘
         │
         ▼
┌────────────────────────┐
│ Redirect ke Detail Page│
└────────┬───────────────┘
         │
         ▼
┌────────────────────────────────────┐
│ Tampilkan Detail Mutasi            │
│ dengan card "Asal" dan "Tujuan"    │
└────────────────────────────────────┘
```

---

## Field Mapping

| Field di Form          | Field di Database | Wajib? | Cara Isi          |
|------------------------|-------------------|--------|-------------------|
| Anggota                | anggota_id        | ✅ Ya  | Manual            |
| Tanggal Mutasi         | tanggal_mutasi    | ✅ Ya  | Manual            |
| DPD Asal               | dpd_dari          | ❌ Tidak | Auto (dari anggota) |
| DPC Asal               | struktur_dari     | ❌ Tidak | Auto (dari anggota) |
| DPD Tujuan             | dpd_ke            | ✅ Ya  | Manual            |
| DPC Tujuan             | struktur_ke       | ❌ Tidak | Manual (Opsional) |
| Alasan Pindah          | alasan_mutasi     | ✅ Ya  | Manual            |
| Alamat Tujuan          | alamat_tujuan     | ✅ Ya  | Manual            |
| Catatan                | catatan           | ❌ Tidak | Manual            |

---

## API Endpoint Baru

### GET `/mutasi/get-anggota-details`

**Parameters:**
- `anggota_id` (required): ID anggota

**Response:**
```json
{
  "dpc_id": 123,
  "dpc_nama": "DPC Jagakarsa",
  "dpd_id": 456,
  "dpd_nama": "Jakarta Selatan"
}
```

**Usage:**
```javascript
fetch('/mutasi/get-anggota-details?anggota_id=123')
  .then(response => response.json())
  .then(data => {
    console.log(data.dpc_nama); // "DPC Jagakarsa"
    console.log(data.dpd_nama); // "Jakarta Selatan"
  });
```

---

## Browser Compatibility
✅ Chrome/Edge (latest)
✅ Firefox (latest)
✅ Safari (latest)
✅ Mobile browsers

## Technologies Used
- Laravel 10
- JavaScript (Vanilla)
- Fetch API
- Bootstrap 5
- MySQL

## Next Steps
1. ✅ Migration sudah dijalankan
2. ✅ Code sudah di-update
3. ✅ Testing manual
4. [ ] User acceptance testing
5. [ ] Deploy ke production

---

**Created by:** Development Team
**Date:** 12 Oktober 2025
**Version:** 1.0

