# Fitur Keranjang Mutasi - Dokumentasi

## Overview
Fitur Keranjang Mutasi memungkinkan administrator untuk mengelola anggota yang telah bermutasi keluar (status Tidak Aktif) dan memberikan kemampuan untuk mengembalikan status mereka menjadi Aktif jika diperlukan.

## Fitur Utama

### 1. Perubahan Status Otomatis
- Ketika mutasi dengan jenis "Keluar" disetujui, status anggota otomatis berubah dari "Aktif" menjadi "Tidak Aktif"
- Perubahan status tercatat dalam database dengan timestamp

### 2. Halaman Keranjang Mutasi
- **URL**: `/mutasi/keranjang`
- **Menu**: Mutasi Anggota > Keranjang Mutasi
- Menampilkan daftar anggota dengan status "Tidak Aktif"
- Filter berdasarkan DPD, DPC, nama anggota, dan tanggal mutasi
- Pagination untuk performa yang baik

### 3. Fitur Pencarian dan Filter
- **Pencarian**: Berdasarkan nama lengkap atau nomor identitas anggota
- **Filter DPD**: Menampilkan anggota berdasarkan DPD asal
- **Filter DPC**: Menampilkan anggota berdasarkan DPC asal
- **Filter Tanggal**: Berdasarkan rentang tanggal mutasi

### 4. Aksi yang Tersedia
- **Lihat Detail Anggota**: Link ke halaman detail anggota
- **Lihat Mutasi**: Link ke detail mutasi yang menyebabkan status berubah
- **Kembalikan Status**: Mengembalikan status anggota menjadi "Aktif"

### 5. Konfirmasi Kembalikan Status
- Modal konfirmasi sebelum mengembalikan status
- Peringatan tentang konsekuensi tindakan
- Pencatatan otomatis dalam catatan mutasi

## Struktur Database

### Tabel `tbl_mutasi`
- `jenis_mutasi`: Enum ('Keluar', 'Penempatan', 'Rekomposisi')
- `status_mutasi`: Enum ('Pending', 'Disetujui', 'Ditolak', 'Dibatalkan')
- `tanggal_sk`: Timestamp persetujuan mutasi
- `nomor_sk`: Nomor surat keputusan

### Tabel `tbl_anggota`
- `status_keanggotaan`: Enum ('Aktif', 'Tidak Aktif', 'Diberhentikan', 'Pindah')

## API Endpoints

### GET `/mutasi/keranjang`
Menampilkan halaman keranjang mutasi dengan filter dan pagination.

**Query Parameters:**
- `search`: Pencarian nama anggota
- `dpd_id`: Filter berdasarkan DPD
- `dpc_id`: Filter berdasarkan DPC
- `tanggal_dari`: Filter tanggal mulai
- `tanggal_sampai`: Filter tanggal akhir

### POST `/mutasi/kembalikan-status/{anggota}`
Mengembalikan status anggota dari "Tidak Aktif" ke "Aktif".

**Response:**
- Success: Redirect dengan pesan sukses
- Error: Redirect dengan pesan error

## Controller Methods

### `MutasiController@keranjangMutasi`
- Menampilkan daftar anggota dengan status "Tidak Aktif"
- Menerapkan filter dan pencarian
- Pagination untuk performa

### `MutasiController@kembalikanStatus`
- Mengubah status anggota menjadi "Aktif"
- Membatalkan mutasi terakhir
- Mencatat log perubahan

## View Components

### `resources/views/mutasi/keranjang.blade.php`
- Tabel responsif dengan data anggota
- Filter form dengan auto-submit
- Modal konfirmasi untuk aksi
- Pagination controls

## Model Enhancements

### `Mutasi` Model
- Scope `keluar()`: Filter mutasi keluar
- Scope `dibatalkan()`: Filter mutasi dibatalkan
- Field `jenis_mutasi` ditambahkan ke fillable

## Navigation Updates

### Sidebar Menu
- Dropdown menu untuk Mutasi Anggota
- Submenu: Daftar Mutasi, Keranjang Mutasi, Buat Mutasi Baru
- Active state management

## Validasi dan Keamanan

### Form Validation
- Validasi jenis mutasi (required, in: Keluar, Penempatan, Rekomposisi)
- Validasi data anggota dan struktur organisasi
- Sanitasi input untuk mencegah XSS

### Authorization
- Hanya admin yang dapat mengakses keranjang mutasi
- Middleware auth untuk semua endpoint

## Error Handling

### Database Transactions
- Semua operasi menggunakan database transaction
- Rollback otomatis jika terjadi error
- Log error untuk debugging

### User Feedback
- Flash messages untuk sukses/error
- Validasi form dengan error display
- Konfirmasi modal untuk aksi kritis

## Performance Optimizations

### Database Queries
- Eager loading untuk relasi
- Index pada kolom yang sering difilter
- Pagination untuk dataset besar

### Caching
- Cache data DPD dan DPC untuk filter
- Optimasi query dengan select specific columns

## Testing Recommendations

### Unit Tests
- Test perubahan status anggota
- Test filter dan pencarian
- Test kembalikan status

### Integration Tests
- Test flow lengkap mutasi keluar
- Test keranjang mutasi dengan berbagai filter
- Test kembalikan status dengan validasi

## Future Enhancements

### Planned Features
- Export data keranjang mutasi ke Excel
- Bulk actions untuk multiple anggota
- History log untuk perubahan status
- Notification system untuk admin

### Performance Improvements
- Redis caching untuk data statis
- Background jobs untuk operasi berat
- API endpoints untuk mobile app

## Troubleshooting

### Common Issues
1. **Anggota tidak muncul di keranjang**: Pastikan status_keanggotaan = 'Tidak Aktif'
2. **Filter tidak bekerja**: Periksa parameter query dan database indexes
3. **Error kembalikan status**: Pastikan mutasi terakhir ada dan valid

### Debug Steps
1. Check database status anggota
2. Verify mutasi records
3. Check application logs
4. Test dengan data sample

## Changelog

### Version 1.0.0
- Initial implementation
- Basic keranjang mutasi functionality
- Status change automation
- Filter and search capabilities
- Return status feature
