# Flow Diagram - Fitur Mutasi dan Keranjang Mutasi

## Diagram Alur Mutasi Keluar

```mermaid
graph TD
    A[Admin Membuat Mutasi Keluar] --> B[Pilih Anggota & Jenis Mutasi]
    B --> C[Isi Data Mutasi]
    C --> D[Submit Mutasi]
    D --> E{Validasi Data}
    E -->|Valid| F[Simpan ke Database]
    E -->|Invalid| G[Tampilkan Error]
    G --> C
    F --> H[Status: Pending]
    H --> I[Admin Review Mutasi]
    I --> J{Approve/Reject}
    J -->|Approve| K[Update Status: Disetujui]
    J -->|Reject| L[Update Status: Ditolak]
    K --> M[Generate Nomor SK]
    M --> N[Ubah Status Anggota: Tidak Aktif]
    N --> O[Anggota Masuk Keranjang Mutasi]
    L --> P[Anggota Tetap Aktif]
    O --> Q[Admin Bisa Lihat di Keranjang]
    Q --> R{Action}
    R -->|Lihat Detail| S[Tampilkan Detail Anggota]
    R -->|Lihat Mutasi| T[Tampilkan Detail Mutasi]
    R -->|Kembalikan Status| U[Konfirmasi Dialog]
    U -->|Ya| V[Ubah Status: Aktif]
    U -->|Tidak| Q
    V --> W[Update Mutasi: Dibatalkan]
    W --> X[Anggota Keluar dari Keranjang]
```

## Diagram Database Relationship

```mermaid
erDiagram
    TBL_ANGGOTA {
        int id PK
        string nama_lengkap
        string nomor_identitas_anggota
        enum status_keanggotaan
        int dpc_id FK
        int dpd_id FK
        datetime created_at
        datetime updated_at
    }
    
    TBL_MUTASI {
        int id PK
        int anggota_id FK
        enum jenis_mutasi
        enum status_mutasi
        date tanggal_mutasi
        datetime tanggal_sk
        string nomor_sk
        text alasan_mutasi
        text catatan
        int disetujui_oleh FK
        datetime created_at
        datetime updated_at
    }
    
    TBL_DPC {
        int dpc_id PK
        string nama_dpc
        int dpd_id FK
        enum status
    }
    
    TBL_DPD {
        int dpd_id PK
        string nama_dpd
        enum status
    }
    
    TBL_USER {
        int id PK
        string name
        string email
    }
    
    TBL_ANGGOTA ||--o{ TBL_MUTASI : "has many"
    TBL_ANGGOTA }o--|| TBL_DPC : "belongs to"
    TBL_ANGGOTA }o--|| TBL_DPD : "belongs to"
    TBL_MUTASI }o--|| TBL_USER : "approved by"
    TBL_DPC }o--|| TBL_DPD : "belongs to"
```

## Diagram Status Flow

```mermaid
stateDiagram-v2
    [*] --> Aktif : Anggota Baru
    
    Aktif --> Pending : Buat Mutasi Keluar
    Pending --> Disetujui : Admin Approve
    Pending --> Ditolak : Admin Reject
    Disetujui --> TidakAktif : Auto Update Status
    Ditolak --> Aktif : Tetap Aktif
    
    TidakAktif --> Aktif : Kembalikan Status
    Aktif --> [*] : Hapus Anggota
    
    note right of TidakAktif
        Anggota masuk ke
        Keranjang Mutasi
    end note
    
    note right of Disetujui
        Generate Nomor SK
        dan Update Timestamp
    end note
```

## Diagram UI Components

```mermaid
graph TB
    A[Sidebar Menu] --> B[Mutasi Anggota Dropdown]
    B --> C[Daftar Mutasi]
    B --> D[Keranjang Mutasi]
    B --> E[Buat Mutasi Baru]
    
    D --> F[Filter & Search Form]
    F --> G[Search Input]
    F --> H[DPD Select]
    F --> I[DPC Select]
    F --> J[Date Range]
    
    D --> K[Data Table]
    K --> L[Anggota Info]
    K --> M[DPC Asal]
    K --> N[Jenjang]
    K --> O[Tanggal Mutasi]
    K --> P[Status Badge]
    K --> Q[Action Buttons]
    
    Q --> R[Lihat Detail]
    Q --> S[Lihat Mutasi]
    Q --> T[Kembalikan Status]
    
    T --> U[Modal Konfirmasi]
    U --> V[Form Submit]
    V --> W[Update Database]
    W --> X[Redirect dengan Message]
```

## Diagram API Flow

```mermaid
sequenceDiagram
    participant U as User/Admin
    participant C as Controller
    participant M as Model
    participant D as Database
    participant V as View
    
    U->>C: GET /mutasi/keranjang
    C->>M: Anggota::where('status_keanggotaan', 'Tidak Aktif')
    M->>D: SELECT with filters
    D-->>M: Return data
    M-->>C: Return collection
    C->>V: Render keranjang view
    V-->>U: Display keranjang page
    
    U->>C: POST /mutasi/kembalikan-status/{id}
    C->>M: Anggota::findOrFail(id)
    M->>D: SELECT anggota
    D-->>M: Return anggota
    C->>M: Update status to 'Aktif'
    M->>D: UPDATE status
    C->>M: Update mutasi to 'Dibatalkan'
    M->>D: UPDATE mutasi
    C-->>U: Redirect with success message
```

## Diagram Error Handling

```mermaid
graph TD
    A[User Action] --> B{Validation}
    B -->|Pass| C[Process Request]
    B -->|Fail| D[Show Validation Error]
    
    C --> E{Database Operation}
    E -->|Success| F[Return Success Response]
    E -->|Error| G[Log Error]
    
    G --> H[Show Error Message]
    G --> I[Rollback Transaction]
    
    D --> J[User Corrects Input]
    J --> A
    
    H --> K[User Retries]
    K --> A
    
    F --> L[Update UI]
    L --> M[Show Success Message]
```

## Diagram Performance Optimization

```mermaid
graph LR
    A[Request] --> B{Cache Check}
    B -->|Hit| C[Return Cached Data]
    B -->|Miss| D[Query Database]
    
    D --> E[Apply Filters]
    E --> F[Eager Load Relations]
    F --> G[Paginate Results]
    G --> H[Cache Result]
    H --> I[Return Data]
    
    C --> I
    I --> J[Render View]
    
    K[Background Job] --> L[Update Cache]
    L --> M[Invalidate Old Cache]
```

## Key Features Summary

### 1. **Automatic Status Change**
- Mutasi "Keluar" yang disetujui → Status anggota menjadi "Tidak Aktif"
- Anggota otomatis masuk ke keranjang mutasi

### 2. **Keranjang Mutasi Management**
- View semua anggota dengan status "Tidak Aktif"
- Advanced filtering dan search
- Pagination untuk performa

### 3. **Status Recovery**
- Admin dapat mengembalikan status anggota menjadi "Aktif"
- Mutasi terakhir otomatis dibatalkan
- Audit trail lengkap

### 4. **User Experience**
- Intuitive UI dengan Bootstrap
- Responsive design
- Real-time feedback
- Confirmation dialogs

### 5. **Data Integrity**
- Database transactions
- Validation rules
- Error handling
- Logging system
