# 📋 Master DPC (Dewan Pimpinan Cabang) - Panduan Lengkap

## 📍 Deskripsi

Master DPC adalah modul untuk mengelola data Dewan Pimpinan Cabang (DPC) dalam sistem manajemen anggota PKS. DPC merupakan struktur organisasi di tingkat cabang yang membawahi beberapa UPA (Unit Pengembangan Anggota).

---

## 🎯 Fitur Utama

### ✅ CRUD Lengkap
- **Create**: Tambah DPC baru
- **Read**: Lihat daftar dan detail DPC
- **Update**: Edit data DPC
- **Delete**: Hapus DPC (dengan validasi)
- **Toggle Status**: Aktifkan/Nonaktifkan DPC

### 🔍 Filter & Pencarian
- Pencarian berdasarkan nama, kode, atau deskripsi DPC
- Filter berdasarkan status (Aktif/Tidak Aktif)
- Filter berdasarkan DPD
- Reset filter untuk melihat semua data

### 📊 Informasi Statistik
- Jumlah UPA di bawah DPC
- Jumlah anggota terdaftar di DPC
- Status aktif DPC

---

## 🗂️ Struktur File

```
app/
├── Http/Controllers/
│   └── DpcController.php          # Controller untuk CRUD DPC
├── Models/
│   └── Dpc.php                     # Model DPC
database/
├── migrations/
│   ├── 2025_09_20_080155_create_dpcs_table.php
│   └── 2025_01_15_000002_fix_dpc_table_structure.php
└── seeders/
    └── DpcSeeder.php               # Seeder data contoh
resources/
└── views/
    └── dpc/
        ├── index.blade.php         # Halaman daftar DPC
        ├── create.blade.php        # Form tambah DPC
        └── edit.blade.php          # Form edit DPC
routes/
└── web.php                         # Routes DPC
```

---

## 🚀 Cara Menggunakan

### 1. Akses Halaman Master DPC

Buka browser dan akses:
```
http://127.0.0.1:8000/dpc
```

### 2. Tambah DPC Baru

**Langkah-langkah:**

1. Klik tombol **"Tambah DPC"** di halaman index
2. Isi form dengan data berikut:
   - **Kode DPC** (required): Kode unik maksimal 10 karakter
     - Contoh: `DPC-CPY`, `DPC-KRJ`
   - **Nama DPC** (required): Nama lengkap DPC maksimal 100 karakter
     - Contoh: `DPC Cipayung`, `DPC Kramat Jati`
   - **DPD**: Pilih DPD yang membawahi (opsional)
   - **Status**: Centang jika DPC aktif
   - **Deskripsi**: Keterangan tambahan (opsional)
3. Klik **"Simpan"**

**Validasi:**
- Kode DPC harus unik (tidak boleh duplikat)
- Nama DPC wajib diisi
- DPD harus valid (jika dipilih)

### 3. Edit DPC

**Langkah-langkah:**

1. Di halaman daftar DPC, klik tombol **Edit** (ikon pensil)
2. Update data yang diperlukan
3. Klik **"Update"**

**Informasi Tambahan:**
- Form edit menampilkan jumlah UPA dan anggota terkait
- Menampilkan tanggal pembuatan data

### 4. Aktifkan/Nonaktifkan DPC

**Langkah-langkah:**

1. Di halaman daftar DPC, klik tombol **Toggle Status**
   - Ikon **Pause** (⏸️) untuk menonaktifkan
   - Ikon **Play** (▶️) untuk mengaktifkan
2. Konfirmasi tindakan

**Catatan:**
- DPC yang dinonaktifkan tidak akan muncul di dropdown pilihan
- Data tetap tersimpan dan bisa diaktifkan kembali

### 5. Hapus DPC

**Langkah-langkah:**

1. Di halaman daftar DPC, klik tombol **Hapus** (ikon tempat sampah)
2. Konfirmasi penghapusan

**Validasi Penghapusan:**
- ❌ **DPC tidak dapat dihapus** jika:
  - Masih memiliki UPA terkait
  - Masih memiliki anggota terdaftar
- ✅ **DPC dapat dihapus** jika tidak ada data terkait

---

## 🔍 Fitur Pencarian & Filter

### Pencarian
Gunakan kotak pencarian untuk mencari DPC berdasarkan:
- Nama DPC
- Kode DPC
- Deskripsi

### Filter Status
- **Semua Status**: Tampilkan semua DPC
- **Aktif**: Tampilkan hanya DPC aktif
- **Tidak Aktif**: Tampilkan hanya DPC tidak aktif

### Filter DPD
Pilih DPD tertentu untuk melihat DPC yang berada di bawahnya

### Reset Filter
Klik tombol **"Reset Filter"** untuk menghapus semua filter dan pencarian

---

## 🗄️ Struktur Database

### Tabel: `tbl_dpc`

| Kolom | Tipe | Deskripsi |
|-------|------|-----------|
| `dpc_id` | BIGINT (PK) | ID unik DPC |
| `kode_dpc` | VARCHAR(10) | Kode DPC (unique) |
| `nama_dpc` | VARCHAR(100) | Nama DPC |
| `dpd_id` | BIGINT (FK) | Foreign key ke tbl_dpd |
| `deskripsi` | TEXT | Deskripsi DPC |
| `is_active` | BOOLEAN | Status aktif (default: true) |
| `created_at` | TIMESTAMP | Waktu dibuat |
| `updated_at` | TIMESTAMP | Waktu diupdate |

### Relasi
- **BelongsTo**: `dpd` - Relasi ke DPD
- **HasMany**: `upa` - Relasi ke UPA
- **HasMany**: `anggota` - Relasi ke Anggota

---

## 💾 Seed Data

Untuk mengisi data contoh DPC, jalankan perintah:

```bash
php artisan db:seed --class=DpcSeeder
```

**Data yang akan dibuat:**
- DPC Cipayung
- DPC Kramat Jati
- DPC Makasar
- DPC Pasar Rebo
- DPC Cakung
- DPC Duren Sawit
- DPC Jatinegara
- DPC Matraman
- DPC Pulo Gadung
- DPC Ciracas

---

## 🔌 API Routes

### Resource Routes

| Method | URI | Name | Controller Method |
|--------|-----|------|------------------|
| GET | `/dpc` | `dpc.index` | `index` |
| GET | `/dpc/create` | `dpc.create` | `create` |
| POST | `/dpc` | `dpc.store` | `store` |
| GET | `/dpc/{dpc}` | `dpc.show` | `show` |
| GET | `/dpc/{dpc}/edit` | `dpc.edit` | `edit` |
| PUT/PATCH | `/dpc/{dpc}` | `dpc.update` | `update` |
| DELETE | `/dpc/{dpc}` | `dpc.destroy` | `destroy` |

### Custom Routes

| Method | URI | Name | Controller Method |
|--------|-----|------|------------------|
| POST | `/dpc/{dpc}/toggle-status` | `dpc.toggle-status` | `toggleStatus` |

---

## 🎨 UI/UX Features

### Halaman Index
- **Card Header**: Judul dan tombol tambah DPC
- **Filter Section**: Pencarian, filter status, dan filter DPD
- **Table**: Daftar DPC dengan informasi lengkap
- **Pagination**: Navigasi halaman (20 item per halaman)
- **Empty State**: Pesan jika tidak ada data

### Halaman Create/Edit
- **Breadcrumb**: Navigasi halaman
- **Form Validation**: Validasi real-time dengan pesan error
- **Helper Text**: Petunjuk pengisian untuk setiap field
- **Button Actions**: Simpan dan Batal

### Color Coding
- 🟢 **Status Aktif**: Badge hijau
- 🔴 **Status Tidak Aktif**: Badge merah
- 🔵 **Kode DPC**: Badge biru info
- ⚫ **DPD**: Badge abu-abu secondary
- 🟣 **Jumlah UPA**: Badge ungu primary
- 🟢 **Jumlah Anggota**: Badge hijau success

---

## 🛠️ Model Methods

### Scopes

```php
// Ambil hanya DPC aktif
$activeDpcs = Dpc::active()->get();
```

### Relationships

```php
// Akses DPD dari DPC
$dpc->dpd; // BelongsTo

// Akses UPA di bawah DPC
$dpc->upa; // HasMany

// Akses anggota di DPC
$dpc->anggota; // HasMany
```

---

## ⚙️ Controller Methods

### `index(Request $request)`
Menampilkan daftar DPC dengan fitur:
- Pencarian
- Filter status
- Filter DPD
- Pagination

### `create()`
Menampilkan form tambah DPC baru

### `store(Request $request)`
Menyimpan DPC baru dengan validasi:
- Kode DPC unik
- Nama DPC required
- DPD valid (jika dipilih)

### `edit(Dpc $dpc)`
Menampilkan form edit DPC

### `update(Request $request, Dpc $dpc)`
Update data DPC dengan validasi yang sama seperti store

### `destroy(Dpc $dpc)`
Hapus DPC dengan validasi:
- Cek apakah ada UPA terkait
- Cek apakah ada anggota terkait

### `toggleStatus(Dpc $dpc)`
Mengubah status aktif/tidak aktif DPC

---

## 🔐 Security & Authorization

Master DPC dilindungi oleh middleware:
- `auth`: User harus login
- `session.security`: Validasi sesi keamanan

**Note:** Tidak ada role-based restriction, semua user yang login dapat mengakses.

---

## 📝 Best Practices

### 1. Penamaan Kode DPC
- Gunakan format konsisten: `DPC-XXX`
- Singkat dan mudah diingat
- Hindari karakter spesial

### 2. Penamaan Nama DPC
- Gunakan nama wilayah yang jelas
- Format: `DPC [Nama Wilayah]`
- Contoh: `DPC Cipayung`, `DPC Kramat Jati`

### 3. Manajemen Status
- Nonaktifkan DPC yang sudah tidak beroperasi
- Jangan langsung hapus, gunakan fitur toggle status
- Hapus hanya jika benar-benar tidak diperlukan

### 4. Hubungan dengan DPD
- Selalu hubungkan DPC dengan DPD yang benar
- Update jika ada perubahan struktur organisasi

---

## 🐛 Troubleshooting

### Error: "Kode DPC sudah digunakan"
**Solusi:** Gunakan kode yang berbeda dan unik

### Error: "DPC tidak dapat dihapus"
**Solusi:** 
1. Pindahkan atau hapus semua UPA terkait terlebih dahulu
2. Pindahkan atau hapus semua anggota terkait terlebih dahulu
3. Atau gunakan fitur toggle status untuk menonaktifkan

### DPC tidak muncul di dropdown
**Solusi:** Pastikan status DPC adalah "Aktif"

---

## 📞 Support

Jika mengalami kendala atau memiliki pertanyaan:
1. Periksa log Laravel di `storage/logs/laravel.log`
2. Periksa console browser untuk error JavaScript
3. Hubungi administrator sistem

---

## 🎓 Related Documentation

- [Master DPD Guide](./MASTER_DPD_GUIDE.md) (Coming Soon)
- [Master UPA Guide](./MASTER_UPA_GUIDE.md) (Coming Soon)
- [Database Schema](./DATABASE_SCHEMA.md)
- [API Documentation](./API_DOCUMENTATION.md)

---

**Terakhir diupdate:** 12 Oktober 2025
**Versi:** 1.0.0



