# Update Layout Dashboard Anggota

## Perubahan Layout
Layout dashboard anggota telah diubah dari 3 kolom menjadi 2+1 layout:

### Sebelum:
```
┌─────────────┬─────────────┬─────────────┐
│ Riwayat     │ Riwayat     │ Kegiatan    │
│ Jenjang     │ Mutasi      │ Terakhir    │
│ (col-md-4)  │ (col-md-4)  │ (col-md-4)  │
└─────────────┴─────────────┴─────────────┘
```

### Sesudah:
```
┌─────────────────────┬─────────────────────┐
│ Riwayat Jenjang     │ Kegiatan Terakhir   │
│ (col-md-6)          │ (col-md-6)          │
└─────────────────────┴─────────────────────┘
┌─────────────────────────────────────────────┐
│ Riwayat Mutasi                              │
│ (col-12)                                    │
└─────────────────────────────────────────────┘
```

## File yang Diupdate:

### `resources/views/anggota/show.blade.php`
- ✅ Ubah `col-md-4` menjadi `col-md-6` untuk Riwayat Jenjang
- ✅ Ubah `col-md-4` menjadi `col-md-6` untuk Kegiatan Terakhir  
- ✅ Pindahkan Riwayat Mutasi ke baris terpisah dengan `col-12`
- ✅ Perbaiki referensi `nama_jenjang` menjadi `jenjang`

## Keuntungan Layout Baru:
- ✅ **Lebih Fokus**: Riwayat Jenjang dan Kegiatan Terakhir mendapat ruang lebih besar
- ✅ **Hierarki Visual**: Riwayat Mutasi di bawah sebagai informasi sekunder
- ✅ **Responsive**: Layout tetap responsif di berbagai ukuran layar
- ✅ **Konsistensi**: Mengikuti pola 2+1 yang umum digunakan

## Struktur HTML:
```html
<!-- Baris 1: 2 Kolom -->
<div class="row">
    <div class="col-md-6">Riwayat Jenjang</div>
    <div class="col-md-6">Kegiatan Terakhir</div>
</div>

<!-- Baris 2: 1 Kolom Penuh -->
<div class="row">
    <div class="col-12">Riwayat Mutasi</div>
</div>
```

## Testing:
1. Buka halaman detail anggota
2. Pastikan layout 2+1 terlihat dengan baik
3. Test responsivitas di berbagai ukuran layar
4. Pastikan semua card tetap berfungsi normal
