# Struktur Fitur Komposisi DPC dan UPA

## Diagram Alur Fitur

```mermaid
graph TD
    A[Dashboard Komposisi] --> B[Detail DPC]
    A --> C[Print Semua]
    B --> D[Detail UPA]
    B --> E[Print DPC]
    D --> F[Print UPA]
    
    A --> A1[Statistik Overview]
    A --> A2[Daftar DPC]
    
    B --> B1[Info DPC]
    B --> B2[Statistik DPC]
    B --> B3[Daftar UPA]
    
    D --> D1[Info UPA]
    D --> D2[Pembimbing Aktif]
    D --> D3[Anggota Aktif]
    
    C --> C1[Semua DPC]
    C --> C2[Semua UPA]
    C --> C3[Semua Anggota]
    
    E --> E1[Info DPC]
    E --> E2[UPA & Anggota]
    
    F --> F1[Info UPA]
    F --> F2[Pembimbing]
    F --> F3[Anggota]
```

## Diagram Relasi Database

```mermaid
erDiagram
    DPD ||--o{ DPC : "has many"
    DPC ||--o{ UPA : "has many"
    DPC ||--o{ ANGGOTA : "has many"
    UPA ||--o{ ANGGOTA : "has many"
    UPA ||--o{ UPA_PEMBIMBING : "has many"
    ANGGOTA ||--o{ UPA_PEMBIMBING : "has many"
    ANGGOTA ||--o{ REF_JENJANG : "belongs to"
    
    DPD {
        int dpd_id PK
        string nama_dpd
        string kode_dpd
    }
    
    DPC {
        int dpc_id PK
        string nama_dpc
        string kode_dpc
        int dpd_id FK
        boolean is_active
    }
    
    UPA {
        int upa_id PK
        string nama_upa
        string kode_upa
        int dpc_id FK
        string status
    }
    
    ANGGOTA {
        int id PK
        string nama_lengkap
        int dpc_id FK
        int upa_id FK
        int ref_jenjang_id FK
        string status_keanggotaan
    }
    
    UPA_PEMBIMBING {
        int upa_id FK
        int anggota_id FK
        string jabatan
        string status
        date tanggal_mulai
    }
    
    REF_JENJANG {
        int ref_jenjang_id PK
        string jenjang
        int urutan
    }
```

## Diagram Arsitektur Controller

```mermaid
graph LR
    A[KomposisiController] --> B[index]
    A --> C[showDpc]
    A --> D[showUpa]
    A --> E[printDpc]
    A --> F[printUpa]
    A --> G[printAll]
    
    B --> B1[getStatistikKomposisi]
    C --> C1[getStatistikDpc]
    D --> D1[getStatistikUpa]
    
    B1 --> H[Database Queries]
    C1 --> H
    D1 --> H
    
    H --> I[DPC Model]
    H --> J[UPA Model]
    H --> K[Anggota Model]
    H --> L[RefJenjang Model]
```

## Diagram User Interface Flow

```mermaid
flowchart TD
    Start([User Login]) --> Menu[Sidebar Menu]
    Menu --> Komposisi[Komposisi DPC & UPA]
    
    Komposisi --> Dashboard[Dashboard Komposisi]
    Dashboard --> Overview[Statistik Overview]
    Dashboard --> DPCList[Daftar DPC]
    
    DPCList --> DPCDetail[Detail DPC]
    DPCDetail --> DPCInfo[Info DPC]
    DPCDetail --> DPCStats[Statistik DPC]
    DPCDetail --> UPAList[Daftar UPA]
    
    UPAList --> UPADetail[Detail UPA]
    UPADetail --> UPAInfo[Info UPA]
    UPADetail --> Pembimbing[Pembimbing Aktif]
    UPADetail --> Anggota[Anggota Aktif]
    
    Dashboard --> PrintAll[Print Semua]
    DPCDetail --> PrintDPC[Print DPC]
    UPADetail --> PrintUPA[Print UPA]
    
    PrintAll --> PrintView[Print View]
    PrintDPC --> PrintView
    PrintUPA --> PrintView
    
    PrintView --> Print[Print Document]
```

## Fitur Print Layout

```mermaid
graph TD
    A[Print Request] --> B{Print Type}
    
    B -->|All| C[Print All Layout]
    B -->|DPC| D[Print DPC Layout]
    B -->|UPA| E[Print UPA Layout]
    
    C --> C1[Header: Semua DPC & UPA]
    C --> C2[Overview Statistics]
    C --> C3[DPC List with UPA]
    C --> C4[Member Details]
    
    D --> D1[Header: DPC Name]
    D --> D2[DPC Information]
    D --> D3[DPC Statistics]
    D --> D4[UPA List in DPC]
    D --> D5[Member Details per UPA]
    
    E --> E1[Header: UPA Name]
    E --> E2[UPA Information]
    E --> E3[UPA Statistics]
    E --> E4[Active Mentors]
    E --> E5[Active Members]
    
    C1 --> F[Print Output]
    C2 --> F
    C3 --> F
    C4 --> F
    D1 --> F
    D2 --> F
    D3 --> F
    D4 --> F
    D5 --> F
    E1 --> F
    E2 --> F
    E3 --> F
    E4 --> F
    E5 --> F
```

## Keunggulan Arsitektur

1. **Modular Design**: Setiap komponen terpisah dan dapat di-maintain secara independen
2. **Reusable Components**: Method helper dapat digunakan ulang di berbagai tempat
3. **Scalable Structure**: Mudah untuk menambah fitur baru atau memodifikasi yang ada
4. **Clean Separation**: Pemisahan yang jelas antara controller, view, dan model
5. **Print Ready**: Format print yang konsisten dan profesional
6. **Responsive Design**: Interface yang adaptif untuk berbagai perangkat
