# Fitur Filter Komposisi DPC dan UPA

## Deskripsi
Fitur filter telah ditambahkan ke halaman komposisi untuk memungkinkan pengguna memfilter data berdasarkan kriteria tertentu. Filter ini membantu pengguna menemukan data yang spesifik dengan mudah.

## Filter yang Tersedia

### 1. Filter DPD
- **Label**: DPD
- **Type**: Dropdown
- **Fungsi**: Memfilter DPC berdasarkan DPD tertentu
- **Options**: Semua DPD yang ada di database
- **Default**: "Semua DPD"

### 2. Filter Status UPA
- **Label**: Status UPA
- **Type**: Dropdown
- **Fungsi**: Memfilter berdasarkan status UPA
- **Options**:
  - Semua Status
  - Aktif
  - Non-Aktif
  - Dibekukan
- **Default**: "Semua Status"

### 3. Filter Jenjang Anggota
- **Label**: Jenjang Anggota
- **Type**: Dropdown
- **Fungsi**: Memfilter DPC yang memiliki anggota dengan jenjang tertentu
- **Options**: Semua jenjang yang ada di database
- **Default**: "Semua Jenjang"

### 4. Filter Minimum Jumlah Anggota
- **Label**: Min. Jumlah Anggota
- **Type**: Dropdown
- **Fungsi**: Memfilter DPC yang memiliki minimal jumlah anggota tertentu
- **Options**:
  - Tidak Ada Batas
  - Min. 1 Anggota
  - Min. 5 Anggota
  - Min. 10 Anggota
  - Min. 20 Anggota
  - Min. 50 Anggota
- **Default**: "Tidak Ada Batas"

## Fitur Filter

### 1. Auto-Submit
- Form filter akan otomatis submit ketika ada perubahan pada dropdown
- Tidak perlu klik tombol "Terapkan Filter" setiap kali

### 2. Filter Active Info
- Menampilkan informasi filter yang sedang aktif
- Ditampilkan dalam alert box di atas statistik
- Format: "Filter Aktif: DPD: [Nama DPD] | Status UPA: [Status] | Jenjang: [Jenjang] | Min. Anggota: [Jumlah]"

### 3. Reset Filter
- Tombol "Reset Filter" untuk menghapus semua filter
- Mengembalikan ke tampilan default (semua data)

### 4. Print Hasil Filter
- Tombol "Print Hasil Filter" muncul ketika ada filter aktif
- Mencetak data sesuai dengan filter yang diterapkan
- Filter information ditampilkan di header print

### 5. Loading State
- Tombol submit menampilkan loading spinner saat memproses
- Mencegah multiple submission

## Implementasi Teknis

### Controller Changes
```php
public function index(Request $request)
{
    $query = Dpc::with(['dpd', 'upa' => function($query) {
        $query->active();
    }])
    ->active();

    // Filter DPD
    if ($request->filled('dpd_id')) {
        $query->where('dpd_id', $request->dpd_id);
    }

    // Filter Status UPA
    if ($request->filled('status_upa')) {
        $query->whereHas('upa', function($q) use ($request) {
            $q->where('status', $request->status_upa);
        });
    }

    // Filter Jenjang Anggota
    if ($request->filled('jenjang_id')) {
        $query->whereHas('anggota', function($q) use ($request) {
            $q->where('ref_jenjang_id', $request->jenjang_id)
              ->where('status_keanggotaan', 'Aktif');
        });
    }

    // Filter berdasarkan jumlah anggota
    if ($request->filled('min_anggota')) {
        $query->whereHas('anggota', function($q) use ($request) {
            $q->where('status_keanggotaan', 'Aktif');
        }, '>=', $request->min_anggota);
    }

    // ... rest of the method
}
```

### View Changes
- Form filter dengan 4 dropdown
- Filter active info display
- Print hasil filter button
- Auto-submit JavaScript

### Print Integration
- Print all method mendukung parameter filter
- Filter information ditampilkan di header print
- Data yang diprint sesuai dengan filter yang diterapkan

## Penggunaan

### 1. Menggunakan Filter
1. Buka halaman komposisi (`/komposisi`)
2. Pilih filter yang diinginkan dari dropdown
3. Form akan otomatis submit dan menampilkan hasil
4. Lihat informasi filter aktif di atas statistik

### 2. Reset Filter
1. Klik tombol "Reset Filter"
2. Semua filter akan dihapus
3. Data kembali ke tampilan default

### 3. Print Hasil Filter
1. Terapkan filter yang diinginkan
2. Klik tombol "Print Hasil Filter"
3. Dokumen print akan menampilkan data sesuai filter

## Contoh Penggunaan

### Filter DPD Jakarta Timur
- Pilih DPD: "Jakarta Timur"
- Hasil: Hanya menampilkan DPC yang berada di Jakarta Timur

### Filter UPA Aktif dengan Min 10 Anggota
- Pilih Status UPA: "Aktif"
- Pilih Min. Jumlah Anggota: "Min. 10 Anggota"
- Hasil: DPC yang memiliki UPA aktif dengan minimal 10 anggota

### Filter Jenjang Kader
- Pilih Jenjang Anggota: "Kader"
- Hasil: DPC yang memiliki anggota dengan jenjang Kader

## Keunggulan

1. **User Friendly**: Interface yang mudah digunakan
2. **Real-time**: Auto-submit untuk pengalaman yang smooth
3. **Flexible**: Kombinasi filter yang fleksibel
4. **Informative**: Menampilkan filter aktif yang jelas
5. **Print Ready**: Print hasil filter dengan informasi lengkap
6. **Performance**: Query yang dioptimasi untuk performa baik

## Catatan Teknis

- Filter menggunakan Laravel Query Builder dengan `whereHas` untuk relasi
- Statistik juga terpengaruh oleh filter yang diterapkan
- Print method mendukung semua parameter filter
- JavaScript untuk auto-submit dan loading state
- Responsive design untuk mobile dan desktop
