# Fitur Komposisi DPC dan UPA

## Deskripsi
Fitur Komposisi DPC dan UPA menyediakan tampilan lengkap tentang struktur organisasi Partai Keadilan Sejahtera, termasuk informasi detail tentang DPC (Dewan Pimpinan Cabang), UPA (Unit Pengembangan Anggota), dan anggota-anggota yang terdaftar di dalamnya.

## Fitur Utama

### 1. Dashboard Komposisi
- **URL**: `/komposisi`
- **Fungsi**: Menampilkan overview semua DPC dan UPA
- **Fitur**:
  - Statistik keseluruhan (Total DPC, UPA, Anggota)
  - Distribusi anggota per jenjang
  - Daftar DPC dengan informasi singkat
  - Tombol akses cepat ke detail dan print

### 2. Detail Komposisi DPC
- **URL**: `/komposisi/dpc/{dpc_id}`
- **Fungsi**: Menampilkan detail lengkap DPC tertentu
- **Fitur**:
  - Informasi lengkap DPC
  - Statistik DPC (Total UPA, Total Anggota)
  - Distribusi anggota per jenjang di DPC
  - Daftar UPA yang berada di bawah DPC
  - Informasi pembimbing dan anggota aktif per UPA

### 3. Detail Komposisi UPA
- **URL**: `/komposisi/upa/{upa_id}`
- **Fungsi**: Menampilkan detail lengkap UPA tertentu
- **Fitur**:
  - Informasi lengkap UPA (alamat, lokasi, status, dll)
  - Statistik UPA (Pembimbing, Anggota Aktif)
  - Distribusi anggota per jenjang di UPA
  - Daftar pembimbing aktif dengan jabatan
  - Daftar anggota aktif lengkap

### 4. Print Komposisi
- **Print DPC**: `/komposisi/dpc/{dpc_id}/print`
- **Print UPA**: `/komposisi/upa/{upa_id}/print`
- **Print Semua**: `/komposisi/print-all`
- **Fitur**:
  - Format print yang rapi dan profesional
  - Informasi lengkap untuk dokumentasi
  - Auto-print saat halaman dibuka
  - Responsive untuk berbagai ukuran kertas

## Struktur Data

### Model yang Digunakan
1. **Dpc** - Data DPC
2. **Upa** - Data UPA
3. **Anggota** - Data anggota
4. **RefJenjang** - Referensi jenjang anggota
5. **Dpd** - Data DPD (untuk relasi)

### Relasi Data
- DPC → UPA (One to Many)
- DPC → Anggota (One to Many)
- UPA → Anggota (One to Many)
- UPA → Pembimbing (Many to Many melalui pivot)
- Anggota → RefJenjang (Many to One)

## Controller

### KomposisiController
**File**: `app/Http/Controllers/KomposisiController.php`

#### Method Utama:
- `index()` - Dashboard komposisi
- `showDpc($dpcId)` - Detail DPC
- `showUpa($upaId)` - Detail UPA
- `printDpc($dpcId)` - Print DPC
- `printUpa($upaId)` - Print UPA
- `printAll()` - Print semua komposisi

#### Method Helper:
- `getStatistikKomposisi()` - Statistik keseluruhan
- `getStatistikDpc($dpcId)` - Statistik DPC tertentu
- `getStatistikUpa($upaId)` - Statistik UPA tertentu

## Views

### 1. Dashboard (`resources/views/komposisi/index.blade.php`)
- Layout utama dengan statistik overview
- Grid DPC dengan informasi singkat
- Tombol akses ke detail dan print

### 2. Detail DPC (`resources/views/komposisi/show-dpc.blade.php`)
- Informasi lengkap DPC
- Statistik DPC
- Daftar UPA dengan informasi anggota

### 3. Detail UPA (`resources/views/komposisi/show-upa.blade.php`)
- Informasi lengkap UPA
- Daftar pembimbing aktif
- Daftar anggota aktif

### 4. Print Views
- `print-dpc.blade.php` - Format print DPC
- `print-upa.blade.php` - Format print UPA
- `print-all.blade.php` - Format print semua komposisi

## Routes

```php
Route::prefix('komposisi')->name('komposisi.')->group(function () {
    Route::get('/', [KomposisiController::class, 'index'])->name('index');
    Route::get('/dpc/{dpc}', [KomposisiController::class, 'showDpc'])->name('show-dpc');
    Route::get('/upa/{upa}', [KomposisiController::class, 'showUpa'])->name('show-upa');
    Route::get('/dpc/{dpc}/print', [KomposisiController::class, 'printDpc'])->name('print-dpc');
    Route::get('/upa/{upa}/print', [KomposisiController::class, 'printUpa'])->name('print-upa');
    Route::get('/print-all', [KomposisiController::class, 'printAll'])->name('print-all');
});
```

## Navigasi
Menu "Komposisi DPC & UPA" telah ditambahkan di sidebar utama dengan ikon sitemap.

## Keunggulan Fitur

1. **Comprehensive**: Menampilkan data lengkap dari level DPC hingga anggota individual
2. **User Friendly**: Interface yang mudah digunakan dengan navigasi yang jelas
3. **Print Ready**: Format print yang profesional untuk dokumentasi
4. **Responsive**: Tampilan yang responsif untuk berbagai perangkat
5. **Real-time**: Data yang ditampilkan selalu terkini sesuai kondisi database
6. **Hierarchical**: Struktur data yang jelas dari DPC → UPA → Anggota

## Penggunaan

1. **Akses Menu**: Klik "Komposisi DPC & UPA" di sidebar
2. **Lihat Overview**: Dashboard menampilkan statistik dan daftar DPC
3. **Detail DPC**: Klik "Detail" pada DPC yang diinginkan
4. **Detail UPA**: Klik "Detail" pada UPA yang diinginkan
5. **Print**: Gunakan tombol "Print" untuk mencetak dokumen

## Catatan Teknis

- Menggunakan eager loading untuk optimasi query
- Data yang ditampilkan hanya anggota dengan status "Aktif"
- Print view menggunakan CSS khusus untuk format kertas
- Auto-print saat halaman print dibuka
- Responsive design untuk mobile dan desktop
