# Fitur Seleksi Partisipan Kegiatan Bertingkat

## Deskripsi
Fitur ini memungkinkan pengguna untuk membuat kegiatan dengan sistem seleksi partisipan bertingkat berdasarkan hierarki organisasi: **DPD → DPC → UPA → Orang**.

## Struktur Hierarki

```
DPD (Daerah Provinsi)
  └── DPC (Daerah Kabupaten/Kota) - bisa lebih dari 1
      └── UPA (Unit Penggerak Anggota) - dalam setiap DPC, UPA tidak harus semua
          └── Orang/Anggota - dalam setiap UPA, orang tidak harus semua
```

## Contoh Penggunaan

### Skenario 1: Seleksi Seluruh DPD
- Pilih: **DPD Jakarta Timur**
- Tambahkan sebagai partisipan
- Hasil: Semua anggota dalam DPD Jakarta Timur akan menjadi partisipan

### Skenario 2: Seleksi Beberapa DPC
- Pilih: **DPD Jakarta Timur** → **DPC Cakung**
- Tambahkan sebagai partisipan
- Pilih: **DPD Jakarta Timur** → **DPC Cipayung**
- Tambahkan sebagai partisipan
- Hasil: Semua anggota dalam DPC Cakung dan DPC Cipayung akan menjadi partisipan

### Skenario 3: Seleksi Beberapa UPA dalam DPC
- Pilih: **DPD Jakarta Timur** → **DPC Cakung** → **UPA Cakung Barat**
- Tambahkan sebagai partisipan
- Pilih: **DPD Jakarta Timur** → **DPC Cakung** → **UPA Cakung Timur**
- Tambahkan sebagai partisipan
- Hasil: Semua anggota dalam UPA Cakung Barat dan UPA Cakung Timur akan menjadi partisipan

### Skenario 4: Seleksi Individu
- Pilih: **DPD Jakarta Timur** → **DPC Cakung** → **UPA Cakung Barat** → **Ahmad Yani**
- Tambahkan sebagai partisipan
- Hasil: Hanya Ahmad Yani yang menjadi partisipan

## Fitur Utama

### 1. Dropdown Bertingkat
- **DPD**: Dropdown pertama untuk memilih provinsi
- **DPC**: Dropdown kedua yang aktif setelah DPD dipilih
- **UPA**: Dropdown ketiga yang aktif setelah DPC dipilih
- **Anggota**: Dropdown keempat yang aktif setelah UPA dipilih

### 2. Status Partisipasi
Setiap partisipan dapat memiliki status:
- **Wajib**: Partisipan wajib hadir
- **Opsional**: Partisipan opsional
- **Undangan**: Partisipan sebagai undangan

### 3. Tabel Partisipan
Menampilkan daftar partisipan yang sudah dipilih dengan informasi:
- **Jenis**: DPD, DPC, UPA, atau Anggota
- **Nama**: Nama entitas yang dipilih
- **Hierarki**: Path hierarki lengkap (contoh: Jakarta Timur → Cakung → Cakung Barat → Ahmad Yani)
- **Status**: Status partisipasi
- **Aksi**: Tombol hapus untuk menghapus partisipan

## Struktur Database

### Tabel: `tbl_kegiatan_partisipan_hierarchical`

| Kolom | Tipe | Deskripsi |
|-------|------|-----------|
| `id` | BIGINT | Primary key |
| `kegiatan_id` | BIGINT | Foreign key ke tbl_kegiatan |
| `dpd_id` | BIGINT (nullable) | Foreign key ke tbl_dpd |
| `dpc_id` | BIGINT (nullable) | Foreign key ke tbl_dpc |
| `upa_id` | BIGINT (nullable) | Foreign key ke tbl_upa |
| `anggota_id` | BIGINT (nullable) | Foreign key ke tbl_anggota |
| `selection_type` | ENUM | Jenis seleksi: 'dpd', 'dpc', 'upa', 'anggota' |
| `status_partisipasi` | ENUM | Status: 'Wajib', 'Opsional', 'Undangan' |
| `status_kehadiran` | ENUM | Status kehadiran: 'Belum Konfirmasi', 'Hadir', 'Tidak Hadir', 'Izin' |
| `keterangan` | TEXT (nullable) | Keterangan tambahan |
| `waktu_konfirmasi` | TIMESTAMP (nullable) | Waktu konfirmasi kehadiran |
| `created_at` | TIMESTAMP | Waktu dibuat |
| `updated_at` | TIMESTAMP | Waktu diupdate |

## File yang Dibuat/Dimodifikasi

### 1. Migration
- `database/migrations/2025_01_15_000003_create_tbl_kegiatan_partisipan_hierarchical_table.php`

### 2. Model
- `app/Models/KegiatanPartisipanHierarchical.php`
- `app/Models/Kegiatan.php` (ditambahkan relasi)

### 3. Controller
- `app/Http/Controllers/KegiatanHierarchicalController.php`

### 4. View
- `resources/views/kegiatan/create-hierarchical.blade.php`

### 5. Routes
- `routes/web.php` (ditambahkan route hierarchical)

## API Endpoints

### 1. GET `/kegiatan/api/dpc-by-dpd`
Mendapatkan daftar DPC berdasarkan DPD yang dipilih.

**Parameters:**
- `dpd_id`: ID DPD

**Response:**
```json
{
  "data": [
    {
      "dpc_id": 1,
      "nama_dpc": "Cakung",
      "kode_dpc": "CKG"
    }
  ]
}
```

### 2. GET `/kegiatan/api/upa-by-dpc`
Mendapatkan daftar UPA berdasarkan DPC yang dipilih.

**Parameters:**
- `dpc_id`: ID DPC

**Response:**
```json
{
  "data": [
    {
      "upa_id": 1,
      "nama_upa": "UPA Cakung Barat",
      "kode_upa": "CKG-BRT"
    }
  ]
}
```

### 3. GET `/kegiatan/api/anggota-by-upa`
Mendapatkan daftar Anggota berdasarkan UPA yang dipilih.

**Parameters:**
- `upa_id`: ID UPA

**Response:**
```json
{
  "data": [
    {
      "id": 1,
      "nama_lengkap": "Ahmad Yani",
      "nomor_identitas_anggota": "NIA001",
      "jenis_kelamin": "Laki-laki"
    }
  ]
}
```

### 4. GET `/kegiatan/api/anggota-by-hierarchy`
Mendapatkan daftar Anggota berdasarkan hierarki yang dipilih.

**Parameters:**
- `dpd_id`: ID DPD (opsional)
- `dpc_id`: ID DPC (opsional)
- `upa_id`: ID UPA (opsional)
- `anggota_id`: ID Anggota (opsional)

**Response:**
```json
{
  "data": [
    {
      "id": 1,
      "nama_lengkap": "Ahmad Yani",
      "nomor_identitas_anggota": "NIA001",
      "jenis_kelamin": "Laki-laki",
      "upa_id": 1,
      "dpc_id": 1,
      "dpd_id": 1,
      "upa": {
        "upa_id": 1,
        "nama_upa": "UPA Cakung Barat"
      },
      "dpc": {
        "dpc_id": 1,
        "nama_dpc": "Cakung"
      },
      "dpd": {
        "dpd_id": 1,
        "nama_dpd": "Jakarta Timur"
      }
    }
  ]
}
```

## Cara Menggunakan

### 1. Akses Halaman Create Kegiatan Hierarchical
```
http://127.0.0.1:8000/kegiatan/create-hierarchical
```

### 2. Isi Informasi Dasar Kegiatan
- Nama Kegiatan
- Jenis Kegiatan
- Deskripsi
- Tanggal dan Waktu
- Tempat

### 3. Seleksi Partisipan
1. Pilih **DPD** dari dropdown pertama
2. Pilih **DPC** dari dropdown kedua (akan aktif setelah DPD dipilih)
3. Pilih **UPA** dari dropdown ketiga (akan aktif setelah DPC dipilih)
4. Pilih **Anggota** dari dropdown keempat (akan aktif setelah UPA dipilih)
5. Pilih **Status Partisipasi** (Wajib/Opsional/Undangan)
6. Klik tombol **"+ Tambah Partisipan"**

### 4. Kelola Partisipan
- Partisipan yang sudah ditambahkan akan muncul di tabel
- Untuk menghapus partisipan, klik tombol **hapus** (ikon trash)
- Anda dapat menambahkan partisipan sebanyak yang diinginkan

### 5. Simpan Kegiatan
- Klik tombol **"Simpan Kegiatan"**
- Sistem akan menyimpan kegiatan beserta partisipan yang dipilih

## Keuntungan Sistem Hierarchical

### 1. Fleksibilitas
- Dapat memilih partisipan di level mana saja (DPD, DPC, UPA, atau Individu)
- Tidak perlu memilih semua anggota satu per satu

### 2. Efisiensi
- Menghemat waktu untuk kegiatan dengan banyak partisipan
- Mudah mengelola partisipan berdasarkan wilayah

### 3. Skalabilitas
- Mudah menambahkan partisipan baru
- Mudah menghapus partisipan yang tidak jadi ikut

### 4. Transparansi
- Path hierarki yang jelas menunjukkan dari mana partisipan berasal
- Status partisipasi yang jelas

## Catatan Penting

### 1. Urutan Route
Route hierarchical **HARUS** didefinisikan **SEBELUM** route resource `kegiatan` di `routes/web.php`. Jika tidak, route resource akan menangkap request terlebih dahulu dan menyebabkan error 404.

**Benar:**
```php
// Hierarchical routes FIRST
Route::prefix('kegiatan')->name('kegiatan.')->group(function () {
    Route::get('create-hierarchical', ...);
    Route::post('store-hierarchical', ...);
});

// Resource routes AFTER
Route::resource('kegiatan', KegiatanController::class);
```

**Salah:**
```php
// Resource routes FIRST (WRONG!)
Route::resource('kegiatan', KegiatanController::class);

// Hierarchical routes AFTER (will not work!)
Route::prefix('kegiatan')->name('kegiatan.')->group(function () {
    Route::get('create-hierarchical', ...);
    Route::post('store-hierarchical', ...);
});
```

### 2. URL API
Pastikan URL API di JavaScript sesuai dengan route yang didefinisikan:
- `/kegiatan/api/dpc-by-dpd`
- `/kegiatan/api/upa-by-dpc`
- `/kegiatan/api/anggota-by-upa`

### 3. Validasi
- Minimal harus memilih DPD untuk menambahkan partisipan
- Sistem akan mencegah duplikasi partisipan

## Testing

### Test Scenario 1: Dropdown Cascade
1. Pilih DPD → DPC dropdown aktif dan terisi
2. Pilih DPC → UPA dropdown aktif dan terisi
3. Pilih UPA → Anggota dropdown aktif dan terisi

### Test Scenario 2: Tambah Partisipan
1. Pilih DPD saja → Tambah → Muncul di tabel dengan jenis "DPD"
2. Pilih DPD + DPC → Tambah → Muncul di tabel dengan jenis "DPC"
3. Pilih DPD + DPC + UPA → Tambah → Muncul di tabel dengan jenis "UPA"
4. Pilih DPD + DPC + UPA + Anggota → Tambah → Muncul di tabel dengan jenis "ANGGOTA"

### Test Scenario 3: Hapus Partisipan
1. Tambah beberapa partisipan
2. Klik tombol hapus pada salah satu partisipan
3. Partisipan hilang dari tabel

## Screenshot

### Halaman Create Kegiatan Hierarchical
![Create Kegiatan Hierarchical](kegiatan-hierarchical-create.png)

### Dropdown Bertingkat Berfungsi
![Dropdown Working](kegiatan-hierarchical-dropdown-working.png)

## Pengembangan Selanjutnya

### 1. Fitur Edit
- Implementasi halaman edit kegiatan dengan seleksi partisipan hierarchical
- Update partisipan yang sudah ada

### 2. Fitur Show/Detail
- Tampilkan detail kegiatan dengan daftar partisipan hierarchical
- Tampilkan jumlah anggota per level (DPD, DPC, UPA)

### 3. Fitur Absensi
- Integrasi dengan sistem absensi
- Generate daftar hadir berdasarkan seleksi hierarchical

### 4. Notifikasi
- Kirim notifikasi ke partisipan berdasarkan level hierarchical
- Email/SMS blast per DPD, DPC, atau UPA

### 5. Laporan
- Laporan kehadiran per DPD, DPC, UPA
- Statistik partisipasi per wilayah

## Troubleshooting

### Error 404 pada `/kegiatan/create-hierarchical`
**Penyebab:** Route hierarchical didefinisikan setelah route resource
**Solusi:** Pindahkan route hierarchical ke atas route resource di `routes/web.php`

### Dropdown DPC/UPA/Anggota tidak terisi
**Penyebab:** URL API salah atau controller method tidak ditemukan
**Solusi:** 
1. Cek URL di JavaScript (harus `/kegiatan/api/...`)
2. Cek route di `routes/web.php`
3. Clear route cache: `php artisan route:clear`

### Alert "Gagal memuat data"
**Penyebab:** API endpoint mengembalikan error
**Solusi:**
1. Cek console browser untuk melihat error detail
2. Cek log Laravel di `storage/logs/laravel.log`
3. Pastikan data DPD/DPC/UPA ada di database

## Kesimpulan

Fitur Seleksi Partisipan Kegiatan Bertingkat memberikan fleksibilitas dan efisiensi dalam mengelola partisipan kegiatan berdasarkan struktur organisasi hierarkis. Dengan sistem dropdown bertingkat, pengguna dapat dengan mudah memilih partisipan di level mana saja tanpa harus memilih satu per satu.
