# Update Urutan Jenjang Anggota

## Perubahan
Urutan dropdown jenjang anggota telah disesuaikan sesuai permintaan:

### Urutan Baru:
1. **Pendukung**
2. **Penggerak** 
3. **Madya**
4. **Dewasa**
5. **Utama**

### File yang Diupdate:

#### 1. Modal Form Dashboard (`resources/views/anggota/show.blade.php`)
```php
// Sebelum:
@foreach(\App\Models\RefJenjang::orderBy('jenjang')->get() as $jenjang)

// Sesudah:
@foreach(\App\Models\RefJenjang::whereIn('jenjang', ['Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama'])->orderByRaw("FIELD(jenjang, 'Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama')")->get() as $jenjang)
```

#### 2. Controller (`app/Http/Controllers/AnggotaKeanggotaanController.php`)
```php
// Sebelum:
$jenjangs = RefJenjang::orderBy('jenjang')->get();

// Sesudah:
$jenjangs = RefJenjang::whereIn('jenjang', ['Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama'])
    ->orderByRaw("FIELD(jenjang, 'Pendukung', 'Penggerak', 'Madya', 'Dewasa', 'Utama')")
    ->get();
```

### Teknologi yang Digunakan:
- **MySQL FIELD()**: Untuk mengurutkan berdasarkan urutan custom
- **whereIn()**: Untuk memfilter hanya jenjang yang diinginkan
- **orderByRaw()**: Untuk menggunakan fungsi MySQL FIELD()

### Hasil:
- Dropdown jenjang sekarang menampilkan urutan yang konsisten
- Hanya menampilkan 5 jenjang yang diminta
- Urutan sesuai dengan hierarki yang diinginkan
- Berlaku di semua form yang menggunakan dropdown jenjang

### Testing:
1. Buka halaman detail anggota
2. Klik "+ Tambah Jenjang" 
3. Lihat dropdown "Jenjang Anggota"
4. Pastikan urutan: Pendukung → Penggerak → Madya → Dewasa → Utama
