# 📋 Panduan Instalasi - Sistem Manajemen Anggota PKS

## 🎯 Overview

Panduan ini akan membantu Anda menginstal dan menjalankan **Sistem Manajemen Anggota PKS** di lingkungan development atau production.

## 📋 Prerequisites

### System Requirements
- **PHP**: 8.2 atau lebih tinggi
- **Composer**: Latest version
- **Node.js**: 16.x atau lebih tinggi
- **NPM**: 8.x atau lebih tinggi
- **Database**: MySQL 8.0+ atau SQLite 3.x
- **Web Server**: Apache/Nginx (untuk production)

### PHP Extensions
Pastikan extension berikut terinstall:
```bash
php -m | grep -E "(openssl|pdo|mbstring|tokenizer|xml|ctype|json|bcmath|fileinfo|gd|curl|zip)"
```

## 🚀 Installation Steps

### 1. Clone Repository

```bash
# Clone repository
git clone <repository-url>
cd bkdpd

# Atau download dan extract ZIP
# Unzip aplikasi.zip ke folder project
```

### 2. Install PHP Dependencies

```bash
# Install Composer dependencies
composer install

# Jika ada masalah dengan memory limit
composer install --no-dev --optimize-autoloader
```

### 3. Install Node.js Dependencies

```bash
# Install NPM dependencies
npm install

# Atau menggunakan Yarn
yarn install
```

### 4. Environment Configuration

```bash
# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate
```

### 5. Database Setup

#### Option A: MySQL (Recommended)

1. **Buat Database**
```sql
CREATE DATABASE bkdpd CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

2. **Konfigurasi .env**
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=bkdpd
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

3. **Run Migrations**
```bash
php artisan migrate
```

#### Option B: SQLite (Development)

1. **Buat Database File**
```bash
touch database/database.sqlite
```

2. **Konfigurasi .env**
```env
DB_CONNECTION=sqlite
DB_DATABASE=database/database.sqlite
```

3. **Run Migrations**
```bash
php artisan migrate
```

### 6. Seed Database

```bash
# Seed dengan data sample
php artisan db:seed

# Atau seed specific seeder
php artisan db:seed --class=AnggotaDemoSeeder
```

### 7. Build Assets

```bash
# Development
npm run dev

# Production
npm run build
```

### 8. Storage Setup

```bash
# Buat symbolic link untuk storage
php artisan storage:link

# Set permissions (Linux/Mac)
chmod -R 775 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### 9. Cache Configuration

```bash
# Clear dan rebuild cache
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear

# Optimize untuk production
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## 🚀 Running Application

### Development Mode

```bash
# Start Laravel development server
php artisan serve

# Aplikasi akan berjalan di http://localhost:8000
```

### Production Mode

#### Apache Configuration

1. **Document Root**
```apache
DocumentRoot /path/to/bkdpd/public
```

2. **Virtual Host**
```apache
<VirtualHost *:80>
    ServerName bkdpd.local
    DocumentRoot /path/to/bkdpd/public
    
    <Directory /path/to/bkdpd/public>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

#### Nginx Configuration

```nginx
server {
    listen 80;
    server_name bkdpd.local;
    root /path/to/bkdpd/public;
    
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

## 🔧 Configuration

### Environment Variables

```env
# Application
APP_NAME="Sistem Manajemen Anggota PKS"
APP_ENV=production
APP_KEY=base64:your-generated-key
APP_DEBUG=false
APP_URL=http://localhost:8000

# Database
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=bkdpd
DB_USERNAME=your_username
DB_PASSWORD=your_password

# Cache
CACHE_DRIVER=file
SESSION_DRIVER=file
QUEUE_CONNECTION=sync

# Mail (Optional)
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-email@gmail.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
```

### Database Configuration

#### MySQL Optimization

```sql
-- Optimize MySQL untuk aplikasi
SET GLOBAL innodb_buffer_pool_size = 1G;
SET GLOBAL max_connections = 200;
SET GLOBAL query_cache_size = 64M;
```

#### Indexes (Sudah included dalam migrations)

Aplikasi sudah memiliki 16+ database indexes untuk performa optimal:
- Primary keys
- Foreign keys
- Search indexes
- Composite indexes

## 🧪 Testing Installation

### 1. Check Application Status

```bash
# Test Laravel
php artisan about

# Test database connection
php artisan tinker
>>> DB::connection()->getPdo();
```

### 2. Access Test URLs

- **Homepage**: http://localhost:8000
- **Login**: http://localhost:8000/login
- **Test Page**: http://localhost:8000/simple.html

### 3. Default Login Credentials

```
Superadmin:
Email: superadmin@bkd.com
Password: password123

Admin:
Email: admin@bkd.com
Password: password123

User:
Email: user@bkd.com
Password: password123
```

## 🐛 Troubleshooting

### Common Issues

#### 1. Composer Memory Error
```bash
# Increase memory limit
php -d memory_limit=2G /usr/local/bin/composer install
```

#### 2. Permission Issues
```bash
# Fix storage permissions
sudo chown -R www-data:www-data storage bootstrap/cache
sudo chmod -R 775 storage bootstrap/cache
```

#### 3. Database Connection Error
```bash
# Check database credentials in .env
# Ensure database exists
# Check MySQL service status
sudo systemctl status mysql
```

#### 4. Asset Not Loading
```bash
# Rebuild assets
npm run build
php artisan storage:link
```

#### 5. Cache Issues
```bash
# Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan view:clear
php artisan route:clear
```

### Performance Issues

#### 1. Slow Database Queries
```bash
# Enable query logging
# Check database indexes
php artisan migrate:status
```

#### 2. High Memory Usage
```bash
# Optimize Composer autoloader
composer dump-autoload --optimize
```

## 📊 Performance Optimization

### 1. Production Optimizations

```bash
# Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache
composer install --no-dev --optimize-autoloader
```

### 2. Database Optimization

- Database indexes sudah dioptimasi
- Query optimization sudah diimplementasi
- Lazy loading untuk relasi

### 3. Asset Optimization

```bash
# Minify assets
npm run build
```

## 🔒 Security Considerations

### 1. Environment Security

```bash
# Set proper file permissions
chmod 600 .env
chmod -R 755 storage
```

### 2. Database Security

- Gunakan user database dengan privilege terbatas
- Enable SSL untuk koneksi database
- Regular backup database

### 3. Application Security

- Data encryption sudah diimplementasi
- CSRF protection aktif
- XSS protection aktif

## 📈 Monitoring

### 1. Log Files

```bash
# Check Laravel logs
tail -f storage/logs/laravel.log

# Check web server logs
tail -f /var/log/apache2/error.log
tail -f /var/log/nginx/error.log
```

### 2. Performance Monitoring

- Gunakan Laravel Telescope (development)
- Monitor database queries
- Check memory usage

## 🚀 Deployment Checklist

- [ ] Environment variables configured
- [ ] Database migrated and seeded
- [ ] Assets built and optimized
- [ ] Storage linked
- [ ] Permissions set correctly
- [ ] Cache optimized
- [ ] SSL certificate installed (production)
- [ ] Backup strategy implemented
- [ ] Monitoring configured

---

**Selamat! Aplikasi Sistem Manajemen Anggota PKS siap digunakan! 🎉**
