# 🚀 GitHub Setup Guide

## 📋 Repository Information
- **GitHub URL:** https://github.com/mahrizalit/bkdpd
- **Clone HTTPS:** https://github.com/mahrizalit/bkdpd.git
- **Clone SSH:** git@github.com:mahrizalit/bkdpd.git

## 🔧 Setup Instructions

### Step 1: Create Repository di GitHub

1. Login ke GitHub: https://github.com
2. Click tombol **"New"** atau buka: https://github.com/new
3. **Repository Settings:**
   - Repository name: `bkdpd`
   - Description: "Sistem Manajemen Anggota PKS (BKD PD)"
   - Visibility: Private (recommended) atau Public
   - ⚠️ JANGAN centang "Add a README file"
   - ⚠️ JANGAN pilih .gitignore atau license
4. Click **"Create repository"**

### Step 2: Connect Local Repository ke GitHub

Anda ada di direktori: `D:\xampp\htdocs\bkdpd`

#### Opsi A: HTTPS (Recommended - Lebih Mudah)

```bash
# Check git status
git status

# Add all files
git add .

# Commit perubahan
git commit -m "Initial commit: Laravel app with CI/CD pipeline"

# Add remote origin
git remote add origin https://github.com/mahrizalit/bkdpd.git

# Check remote
git remote -v

# Push to GitHub
git push -u origin feature/unified-transfer-system
```

**Jika diminta login:**
- Username: `mahrizalit`
- Password: Gunakan **Personal Access Token** (bukan password GitHub)

**Cara buat Personal Access Token:**
1. GitHub → Settings → Developer settings → Personal access tokens → Tokens (classic)
2. Generate new token (classic)
3. Pilih scopes: `repo` (full control of private repositories)
4. Generate token
5. **Copy token** (simpan, tidak akan muncul lagi!)
6. Gunakan sebagai password saat push

#### Opsi B: SSH (Lebih Aman - Butuh Setup SSH Key)

```bash
# Generate SSH key (jika belum punya)
ssh-keygen -t ed25519 -C "your-email@example.com"
# Press Enter untuk default location
# Enter passphrase (optional)

# Copy SSH public key
cat ~/.ssh/id_ed25519.pub
# atau di Windows:
type %USERPROFILE%\.ssh\id_ed25519.pub

# Add SSH key ke GitHub:
# 1. GitHub → Settings → SSH and GPG keys → New SSH key
# 2. Paste public key
# 3. Click "Add SSH key"

# Test SSH connection
ssh -T git@github.com

# Add remote origin (SSH)
git remote add origin git@github.com:mahrizalit/bkdpd.git

# Push to GitHub
git push -u origin feature/unified-transfer-system
```

### Step 3: Verify Upload

Setelah push berhasil:
1. Buka: https://github.com/mahrizalit/bkdpd
2. Refresh page
3. Anda akan lihat semua files uploaded
4. Cek tab **Actions** - CI/CD akan otomatis run!

## 🔄 Git Commands Cheat Sheet

### Daily Workflow

```bash
# Check status
git status

# See current branch
git branch

# Create new branch
git checkout -b feature/nama-fitur

# Add files
git add .

# Commit changes
git commit -m "Deskripsi perubahan"

# Push to GitHub
git push origin nama-branch

# Pull latest changes
git pull origin main

# Merge branch
git checkout main
git merge feature/nama-fitur
git push origin main
```

### Branch Management

```bash
# List all branches
git branch -a

# Switch branch
git checkout nama-branch

# Create and switch
git checkout -b nama-branch-baru

# Delete branch (local)
git branch -d nama-branch

# Delete branch (remote)
git push origin --delete nama-branch
```

### Check Remote

```bash
# List remotes
git remote -v

# Remove remote
git remote remove origin

# Change remote URL
git remote set-url origin https://github.com/mahrizalit/bkdpd.git
```

## 🚨 Troubleshooting

### Error: "Repository not found"

**Penyebab:**
- Repository belum dibuat di GitHub
- URL remote salah
- Tidak punya akses ke repository

**Solusi:**
```bash
# Check remote URL
git remote -v

# Remove wrong remote
git remote remove origin

# Add correct remote
git remote add origin https://github.com/mahrizalit/bkdpd.git

# Try push again
git push -u origin feature/unified-transfer-system
```

### Error: "Authentication failed"

**HTTPS - Penyebab:**
- Username/password salah
- Password GitHub tidak bisa digunakan (deprecated)
- Harus pakai Personal Access Token

**Solusi:**
```bash
# Generate Personal Access Token:
# 1. GitHub → Settings → Developer settings
# 2. Personal access tokens → Tokens (classic)
# 3. Generate new token
# 4. Select scopes: repo
# 5. Copy token

# Use token as password when pushing
git push origin feature/unified-transfer-system
# Username: mahrizalit
# Password: ghp_xxxxxxxxxxxx (paste token)
```

**SSH - Penyebab:**
- SSH key belum di-setup
- SSH key tidak terdaftar di GitHub

**Solusi:**
```bash
# Generate SSH key
ssh-keygen -t ed25519 -C "your-email@example.com"

# Copy public key
cat ~/.ssh/id_ed25519.pub

# Add ke GitHub → Settings → SSH keys
```

### Error: "Permission denied"

**Penyebab:**
- Tidak punya write access ke repository
- SSH key tidak valid

**Solusi:**
```bash
# Pastikan Anda owner/collaborator repository
# Atau gunakan HTTPS dengan token
git remote set-url origin https://github.com/mahrizalit/bkdpd.git
```

### Error: "Updates were rejected"

**Penyebab:**
- Remote branch lebih baru dari local
- Ada conflict

**Solusi:**
```bash
# Pull latest changes first
git pull origin feature/unified-transfer-system --rebase

# Resolve conflicts jika ada
# Lalu push
git push origin feature/unified-transfer-system
```

## 📊 Git Best Practices

### Commit Messages

**Good:**
```bash
git commit -m "Add CI/CD pipeline with GitHub Actions"
git commit -m "Fix: Resolve mutasi approval bug"
git commit -m "Update: Improve dashboard performance"
```

**Bad:**
```bash
git commit -m "update"
git commit -m "fix bug"
git commit -m "changes"
```

### Branch Naming

**Good:**
```
feature/user-management
bugfix/login-error
hotfix/security-patch
```

**Bad:**
```
my-branch
test
branch1
```

### .gitignore Best Practices

Sudah di-setup di `.gitignore`:
```
/vendor
/node_modules
.env
/storage/*.key
/public/hot
/public/build
/bkdpd
```

## 🎯 Quick Setup Commands

**Complete setup dari awal:**

```bash
# 1. Check git config
git config --global user.name "Your Name"
git config --global user.email "your-email@example.com"

# 2. Initialize git (jika belum)
# git init  # Skip jika sudah ada .git folder

# 3. Check current status
git status

# 4. Stage all files
git add .

# 5. Commit
git commit -m "Initial commit: Laravel app with CI/CD"

# 6. Add remote
git remote add origin https://github.com/mahrizalit/bkdpd.git

# 7. Push to GitHub
git push -u origin feature/unified-transfer-system

# 8. Create main branch from feature
git checkout -b main
git push -u origin main
```

## ✅ Verification Checklist

- [ ] Repository created di GitHub
- [ ] Git remote configured correctly
- [ ] First commit pushed successfully
- [ ] Files visible di GitHub
- [ ] GitHub Actions running (check Actions tab)
- [ ] CI tests passing (green checkmark)
- [ ] Branch protection configured (optional)

## 🚀 Next Steps After Push

1. **Enable GitHub Actions** (jika belum):
   - Settings → Actions → General
   - Allow all actions

2. **Check CI/CD**:
   - Buka tab **Actions**
   - Lihat workflow runs
   - CI akan otomatis test code

3. **Setup Deployment** (optional):
   - Add secrets untuk deployment
   - Lihat [CI_CD_SETUP.md](CI_CD_SETUP.md)

4. **Branch Protection** (recommended):
   - Settings → Branches → Add rule
   - Branch name pattern: `main`
   - Enable: "Require status checks to pass"

## 📚 Resources

- [GitHub Docs](https://docs.github.com)
- [Git Documentation](https://git-scm.com/doc)
- [Pro Git Book](https://git-scm.com/book/en/v2)
- [GitHub Actions](https://docs.github.com/en/actions)

## 📞 Support

Jika masih ada masalah:
1. Check error message dengan teliti
2. Cari di GitHub Community
3. Lihat troubleshooting guide di atas

---

**Status:** Ready to push! 🚀

