# Perbaikan Tampilan UPA di Riwayat Jenjang

## Masalah
Di card "Riwayat Jenjang", masih menampilkan "UPA 1" (nama grup UPA) padahal seharusnya menampilkan nama UPA yang sebenarnya seperti "UPA Al-Fallah".

## Solusi
Menambahkan kembali field `upa_id` ke dalam sistem history dan menampilkan nama UPA yang benar.

## File yang Diupdate:

### 1. Model AnggotaJenjangHistory (`app/Models/AnggotaJenjangHistory.php`)
- ✅ Tambah `upa_id` ke method `createHistory()`
- ✅ Field `upa_id` sudah ada di migration dan fillable

### 2. Model Anggota (`app/Models/Anggota.php`)
- ✅ Tambah `upa_id` ke method `updateKeanggotaanData()`
- ✅ Tambah `upa_id` ke method `saveToHistory()`

### 3. Controller (`app/Http/Controllers/AnggotaKeanggotaanController.php`)
- ✅ Tambah validasi `upa_id` di method `update()`
- ✅ Tambah `upa_id` ke update data di method `update()`

### 4. View (`resources/views/anggota/show.blade.php`)
- ✅ Tambah field UPA ke form modal
- ✅ Tambah JavaScript auto-update UPA berdasarkan Grup UPA
- ✅ Tambah badge UPA di card Riwayat Jenjang:
  ```html
  @if($history->upa)
      <span class="badge bg-info">{{ $history->upa->nama_upa }}</span>
  @endif
  ```

## Tampilan Sekarang:
```
┌─────────────────────────────────────┐
│ Riwayat Jenjang                     │
├─────────────────────────────────────┤
│ 🔵 Pendukung                        │
│    28 Sep 2025                      │
│    [UPA 1] [UPA Al-Fallah] [Cakung] │
│    pindah ke UPA Al-Fallah          │
└─────────────────────────────────────┘
```

## Badge yang Ditampilkan:
- **UPA 1** (orange) - Grup UPA
- **UPA Al-Fallah** (blue) - Nama UPA sebenarnya  
- **Cakung** (green) - DPC

## Form Modal Sekarang:
- ✅ Jenjang Anggota (required)
- ✅ Grup UPA (required) - auto-update UPA
- ✅ DPC (required)
- ✅ DPD (required)
- ✅ UPA (optional) - dinamis berdasarkan Grup UPA
- ✅ Status Keanggotaan (required)
- ✅ Tanggal Perubahan (required)
- ✅ Keterangan (optional)

## Testing:
1. Buka halaman detail anggota
2. Klik "+ Tambah Jenjang"
3. Pilih Grup UPA → UPA akan auto-update
4. Simpan data
5. Lihat card Riwayat Jenjang → nama UPA sebenarnya akan muncul
