# 🔌 API Documentation - Sistem Manajemen Anggota PKS

## 📋 Overview

Dokumentasi API untuk **Sistem Manajemen Anggota PKS**. API ini menyediakan endpoints untuk mengakses dan mengelola data anggota, mutasi, kegiatan, dan laporan.

## 🌐 Base URL

```
Development: http://localhost:8000
Production: https://your-domain.com
```

## 🔐 Authentication

### Authentication Method
- **Type**: Session-based authentication
- **Middleware**: `auth` dan `session.security`
- **Login Endpoint**: `POST /login`
- **Logout Endpoint**: `POST /logout`

### Headers
```http
Content-Type: application/json
Accept: application/json
X-CSRF-TOKEN: your-csrf-token
```

## 👥 Anggota API

### 1. Get All Anggota
```http
GET /anggota
```

**Query Parameters:**
- `page` (int): Page number (default: 1)
- `per_page` (int): Items per page (default: 15)
- `search` (string): Search term
- `status` (string): Filter by status
- `jenjang` (string): Filter by jenjang
- `dpc_id` (int): Filter by DPC
- `dpd_id` (int): Filter by DPD

**Response:**
```json
{
    "data": [
        {
            "id": 1,
            "nomor_identitas_anggota": "PKS-001-2025",
            "nama_lengkap": "John Doe",
            "tempat_lahir": "Jakarta",
            "tanggal_lahir": "1990-01-01",
            "jenis_kelamin": "L",
            "alamat_jalan": "Jl. Contoh No. 123",
            "rt": "001",
            "rw": "002",
            "kelurahan": "Kelurahan Contoh",
            "kecamatan": "Kecamatan Contoh",
            "kota": "Jakarta Timur",
            "provinsi": "DKI Jakarta",
            "kode_pos": "12345",
            "no_telepon": "08123456789",
            "email": "john@example.com",
            "ref_jenjang_id": 1,
            "ref_grup_upa_id": 1,
            "upa_id": 1,
            "dpc_id": 1,
            "dpd_id": 1,
            "tanggal_bergabung": "2025-01-01",
            "status_keanggotaan": "Aktif",
            "penghasilan_per_bulan": 5000000.00,
            "muzaki_mustahiq": "Muzaki",
            "foto": "storage/photos/anggota/1.jpg",
            "umur": 34,
            "alamat_lengkap": "Jl. Contoh No. 123, RT 001/RW 002, Kelurahan Contoh, Kecamatan Contoh, Jakarta Timur, DKI Jakarta",
            "lama_keanggotaan": "1 month ago",
            "created_at": "2025-01-01T00:00:00.000000Z",
            "updated_at": "2025-01-01T00:00:00.000000Z"
        }
    ],
    "current_page": 1,
    "last_page": 5,
    "per_page": 15,
    "total": 75
}
```

### 2. Get Single Anggota
```http
GET /anggota/{id}
```

**Response:**
```json
{
    "id": 1,
    "nomor_identitas_anggota": "PKS-001-2025",
    "nama_lengkap": "John Doe",
    // ... other fields
    "mutasi": [
        {
            "id": 1,
            "jenis_mutasi": "Pindah",
            "tanggal_mutasi": "2025-01-15",
            "status_mutasi": "Disetujui"
        }
    ],
    "absensi_kegiatan": [
        {
            "id": 1,
            "kegiatan_id": 1,
            "waktu_checkin": "2025-01-20T08:00:00.000000Z",
            "status": "hadir"
        }
    ]
}
```

### 3. Create Anggota
```http
POST /anggota
```

**Request Body:**
```json
{
    "nama_lengkap": "Jane Doe",
    "tempat_lahir": "Bandung",
    "tanggal_lahir": "1992-05-15",
    "jenis_kelamin": "P",
    "alamat_jalan": "Jl. Contoh No. 456",
    "rt": "003",
    "rw": "004",
    "kelurahan": "Kelurahan Baru",
    "kecamatan": "Kecamatan Baru",
    "kota": "Bandung",
    "provinsi": "Jawa Barat",
    "kode_pos": "40111",
    "no_telepon": "08123456790",
    "email": "jane@example.com",
    "ref_jenjang_id": 2,
    "ref_grup_upa_id": 2,
    "upa_id": 2,
    "dpc_id": 2,
    "dpd_id": 2,
    "tanggal_bergabung": "2025-01-01",
    "status_keanggotaan": "Aktif",
    "penghasilan_per_bulan": 6000000.00,
    "muzaki_mustahiq": "Muzaki"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Anggota berhasil ditambahkan",
    "data": {
        "id": 2,
        "nomor_identitas_anggota": "PKS-002-2025",
        // ... other fields
    }
}
```

### 4. Update Anggota
```http
PUT /anggota/{id}
```

**Request Body:** Same as create

**Response:**
```json
{
    "success": true,
    "message": "Anggota berhasil diperbarui",
    "data": {
        // Updated anggota data
    }
}
```

### 5. Delete Anggota
```http
DELETE /anggota/{id}
```

**Response:**
```json
{
    "success": true,
    "message": "Anggota berhasil dihapus"
}
```

### 6. Search Anggota
```http
GET /anggota/api/search?q={search_term}
```

**Response:**
```json
{
    "data": [
        {
            "id": 1,
            "nama_lengkap": "John Doe",
            "nomor_identitas_anggota": "PKS-001-2025",
            "no_telepon": "08123456789"
        }
    ]
}
```

### 7. Export Anggota
```http
GET /anggota/export?format=excel&status=Aktif&dpc_id=1
```

**Query Parameters:**
- `format`: `excel` atau `pdf`
- `status`: Filter by status
- `dpc_id`: Filter by DPC
- `dpd_id`: Filter by DPD

**Response:** File download

### 8. Import Anggota
```http
POST /anggota/import
```

**Request:** Multipart form with Excel file

**Response:**
```json
{
    "success": true,
    "message": "File berhasil diupload",
    "preview_data": [
        // Preview of imported data
    ]
}
```

## 🔄 Mutasi API

### 1. Get All Mutasi
```http
GET /mutasi
```

**Query Parameters:**
- `page` (int): Page number
- `status` (string): Filter by status
- `jenis_mutasi` (string): Filter by jenis mutasi
- `tanggal_dari` (date): Filter from date
- `tanggal_sampai` (date): Filter to date

**Response:**
```json
{
    "data": [
        {
            "id": 1,
            "anggota_id": 1,
            "jenis_mutasi": "Pindah",
            "struktur_dari": 1,
            "struktur_ke": 2,
            "tanggal_mutasi": "2025-01-15",
            "alasan_mutasi": "Pindah domisili",
            "nomor_sk": "006/D/Mts/A1-04-PKS/IX/2025",
            "status_mutasi": "Disetujui",
            "anggota": {
                "id": 1,
                "nama_lengkap": "John Doe",
                "nomor_identitas_anggota": "PKS-001-2025"
            },
            "struktur_dari_detail": {
                "id": 1,
                "nama_struktur": "DPC Jakarta Timur"
            },
            "struktur_ke_detail": {
                "id": 2,
                "nama_struktur": "DPC Jakarta Selatan"
            }
        }
    ],
    "current_page": 1,
    "last_page": 3,
    "per_page": 15,
    "total": 45
}
```

### 2. Create Mutasi
```http
POST /mutasi
```

**Request Body:**
```json
{
    "anggota_id": 1,
    "jenis_mutasi": "Pindah",
    "struktur_dari": 1,
    "struktur_ke": 2,
    "tanggal_mutasi": "2025-01-15",
    "alasan_mutasi": "Pindah domisili",
    "catatan": "Mutasi karena pindah domisili"
}
```

### 3. Approve Mutasi
```http
POST /mutasi/{id}/approve
```

**Request Body:**
```json
{
    "nomor_sk": "006/D/Mts/A1-04-PKS/IX/2025",
    "tanggal_sk": "2025-01-15",
    "disetujui_oleh": "Ketua DPD",
    "catatan": "Disetujui"
}
```

### 4. Reject Mutasi
```http
POST /mutasi/{id}/reject
```

**Request Body:**
```json
{
    "catatan": "Alasan penolakan"
}
```

### 5. Print Surat Mutasi
```http
GET /mutasi/{id}/print-surat
```

**Response:** PDF file download

## 📅 Kegiatan API

### 1. Get All Kegiatan
```http
GET /kegiatan
```

**Query Parameters:**
- `page` (int): Page number
- `jenis_kegiatan` (string): Filter by jenis
- `status_kegiatan` (string): Filter by status
- `tanggal_dari` (date): Filter from date
- `tanggal_sampai` (date): Filter to date

**Response:**
```json
{
    "data": [
        {
            "id": 1,
            "kode_kegiatan": "KEG-001-2025",
            "nama_kegiatan": "Rapat Koordinasi",
            "jenis_kegiatan": "Rapat",
            "tanggal_mulai": "2025-01-20T08:00:00.000000Z",
            "tanggal_selesai": "2025-01-20T17:00:00.000000Z",
            "tempat": "Gedung PKS",
            "status_kegiatan": "Planned",
            "pic_kegiatan": "Ahmad Yani",
            "partisipan_count": 25,
            "absensi_count": 20
        }
    ]
}
```

### 2. Create Kegiatan
```http
POST /kegiatan
```

**Request Body:**
```json
{
    "nama_kegiatan": "Rapat Koordinasi",
    "jenis_kegiatan": "Rapat",
    "tanggal_mulai": "2025-01-20 08:00:00",
    "tanggal_selesai": "2025-01-20 17:00:00",
    "tempat": "Gedung PKS",
    "alamat_tempat": "Jl. Contoh No. 123",
    "pic_kegiatan": "Ahmad Yani",
    "uraian_kegiatan": "Rapat koordinasi bulanan"
}
```

### 3. Get Absensi Kegiatan
```http
GET /kegiatan/{id}/absensi
```

**Response:**
```json
{
    "kegiatan": {
        "id": 1,
        "nama_kegiatan": "Rapat Koordinasi",
        "tanggal_mulai": "2025-01-20T08:00:00.000000Z"
    },
    "absensi": [
        {
            "id": 1,
            "anggota_id": 1,
            "anggota": {
                "nama_lengkap": "John Doe",
                "nomor_identitas_anggota": "PKS-001-2025"
            },
            "waktu_checkin": "2025-01-20T08:15:00.000000Z",
            "status": "hadir",
            "keterangan": null
        }
    ]
}
```

### 4. Store Absensi
```http
POST /kegiatan/{id}/absensi
```

**Request Body:**
```json
{
    "anggota_id": 1,
    "status": "hadir",
    "keterangan": "Hadir tepat waktu"
}
```

## 📊 Takwim API

### 1. Get All Takwim
```http
GET /takwim
```

**Response:**
```json
{
    "data": [
        {
            "id": 1,
            "nama_takwim": "Program Kaderisasi",
            "deskripsi": "Program kaderisasi berkelanjutan",
            "tanggal_mulai": "2025-01-01",
            "tanggal_selesai": "2025-12-31",
            "koordinator": "Ahmad Yani",
            "status_takwim": "Aktif",
            "peserta_count": 15
        }
    ]
}
```

### 2. Add Peserta Takwim
```http
POST /takwim/{id}/peserta
```

**Request Body:**
```json
{
    "anggota_id": 1,
    "status_peserta": "Aktif"
}
```

### 3. Remove Peserta Takwim
```http
DELETE /takwim/{id}/peserta/{anggota_id}
```

## 📈 Laporan API

### 1. Get Laporan Anggota
```http
GET /laporan/anggota
```

**Query Parameters:**
- `format` (string): `excel` atau `pdf`
- `status` (string): Filter by status
- `dpc_id` (int): Filter by DPC
- `dpd_id` (int): Filter by DPD
- `tanggal_dari` (date): Filter from date
- `tanggal_sampai` (date): Filter to date

**Response:** File download atau JSON data

### 2. Get Laporan Mutasi
```http
GET /laporan/mutasi
```

### 3. Get Laporan Kegiatan
```http
GET /laporan/kegiatan
```

### 4. Get Laporan Kehadiran
```http
GET /laporan/kehadiran
```

## 📊 Statistik API

### 1. Get Dashboard Stats
```http
GET /statistik
```

**Response:**
```json
{
    "total_anggota": 150,
    "anggota_aktif": 140,
    "total_mutasi": 25,
    "mutasi_pending": 5,
    "total_kegiatan": 30,
    "kegiatan_ongoing": 3,
    "total_takwim": 8,
    "takwim_aktif": 6,
    "chart_data": {
        "anggota_per_jenjang": [
            {"jenjang": "Kader", "count": 50},
            {"jenjang": "Kader Madya", "count": 30},
            {"jenjang": "Kader Utama", "count": 20}
        ],
        "mutasi_per_bulan": [
            {"bulan": "Januari", "count": 5},
            {"bulan": "Februari", "count": 8}
        ]
    }
}
```

### 2. Get Anggota Statistics
```http
GET /statistik/anggota
```

### 3. Get Kegiatan Statistics
```http
GET /statistik/kegiatan
```

### 4. Get Mutasi Statistics
```http
GET /statistik/mutasi
```

## 🔍 Search API

### 1. Search Anggota
```http
GET /api/anggota/search?q={search_term}
```

### 2. Get Anggota Paginated
```http
GET /api/anggota-paginated?page=1&per_page=15
```

### 3. Get Struktur Organisasi
```http
GET /api/struktur-organisasi
```

## 📍 Address API

### 1. Get Provinsi
```http
GET /api/provinsi
```

**Response:**
```json
[
    {
        "id": 1,
        "kode_provinsi": "31",
        "nama_provinsi": "DKI Jakarta",
        "is_active": true
    }
]
```

### 2. Get Kota by Provinsi
```http
GET /api/kota?provinsi_id=1
```

### 3. Get Kecamatan by Kota
```http
GET /api/kecamatan?kota_id=1
```

### 4. Get Kelurahan by Kecamatan
```http
GET /api/kelurahan?kecamatan_id=1
```

### 5. Get DPC by DPD
```http
GET /api/dpc-by-dpd/{dpd_id}
```

### 6. Get UPA by DPC
```http
GET /api/upa-by-dpc/{dpc_ids}
```

## 🔐 Authentication API

### 1. Login
```http
POST /login
```

**Request Body:**
```json
{
    "email": "admin@bkd.com",
    "password": "password123",
    "remember": true
}
```

**Response:**
```json
{
    "success": true,
    "message": "Login berhasil",
    "user": {
        "id": 1,
        "name": "Administrator",
        "email": "admin@bkd.com",
        "role": "admin"
    }
}
```

### 2. Logout
```http
POST /logout
```

**Response:**
```json
{
    "success": true,
    "message": "Logout berhasil"
}
```

### 3. Change Password
```http
POST /change-password
```

**Request Body:**
```json
{
    "current_password": "old_password",
    "new_password": "new_password",
    "new_password_confirmation": "new_password"
}
```

## 📱 Check-in API (Public)

### 1. Get Check-in Page
```http
GET /checkin/{kegiatan_id}
```

### 2. Search Anggota for Check-in
```http
POST /checkin/{kegiatan_id}/search
```

**Request Body:**
```json
{
    "search_term": "John Doe"
}
```

### 3. Check-in Anggota
```http
POST /checkin/{kegiatan_id}/checkin
```

**Request Body:**
```json
{
    "anggota_id": 1
}
```

### 4. Get Check-in Stats
```http
GET /checkin/{kegiatan_id}/stats
```

### 5. Generate QR Code
```http
GET /checkin/{kegiatan_id}/qr
```

## ❌ Error Responses

### 400 Bad Request
```json
{
    "success": false,
    "message": "Validation failed",
    "errors": {
        "nama_lengkap": ["Nama lengkap harus diisi"],
        "email": ["Format email tidak valid"]
    }
}
```

### 401 Unauthorized
```json
{
    "success": false,
    "message": "Unauthenticated"
}
```

### 403 Forbidden
```json
{
    "success": false,
    "message": "Access denied"
}
```

### 404 Not Found
```json
{
    "success": false,
    "message": "Data tidak ditemukan"
}
```

### 422 Unprocessable Entity
```json
{
    "success": false,
    "message": "Data tidak valid",
    "errors": {
        "field_name": ["Error message"]
    }
}
```

### 500 Internal Server Error
```json
{
    "success": false,
    "message": "Terjadi kesalahan server"
}
```

## 🔧 Rate Limiting

- **Default**: 60 requests per minute per IP
- **API Endpoints**: 100 requests per minute per user
- **Search Endpoints**: 30 requests per minute per user

## 📝 Response Format

### Success Response
```json
{
    "success": true,
    "message": "Operation successful",
    "data": {
        // Response data
    }
}
```

### Paginated Response
```json
{
    "data": [
        // Array of items
    ],
    "current_page": 1,
    "last_page": 5,
    "per_page": 15,
    "total": 75,
    "from": 1,
    "to": 15
}
```

## 🚀 Testing API

### Using cURL
```bash
# Get all anggota
curl -X GET "http://localhost:8000/anggota" \
  -H "Accept: application/json"

# Create anggota
curl -X POST "http://localhost:8000/anggota" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "nama_lengkap": "John Doe",
    "tempat_lahir": "Jakarta",
    "tanggal_lahir": "1990-01-01",
    "jenis_kelamin": "L"
  }'
```

### Using Postman
1. Import collection dari file `API_Collection.postman_collection.json`
2. Set base URL ke `http://localhost:8000`
3. Login untuk mendapatkan session
4. Test endpoints

---

**API ini menyediakan akses lengkap ke semua fitur Sistem Manajemen Anggota PKS! 🚀**
